/***************************************************************************
 *   Copyright (C) 2004 by  ͤ                                            *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "importdixchangecommand.h"
#include "word.h"
#include "cannadic.h"
#include "dixchange.h"
#include "worditem.h"

#include <qcursor.h>
#include <kconfig.h>
#include <kurl.h>
#include <qtextcodec.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <qapplication.h>
#include <kio/netaccess.h>
#include <qfile.h>
#include <qtextstream.h>

ImportDixchangeCommand::ImportDixchangeCommand( KListView* parent )
{
	m_succeed = false;
	m_parent = parent;

	KConfig *conf = KGlobal::config();
	conf->setGroup("ImportDixchangeCommand");
	QString startdir = conf->readEntry( "StartDir", QString::null );

	KURL url = KFileDialog::getOpenURL( startdir
		, i18n("*.dxc|Dixchange style text dictionary files(*.dxc)\n*.txt|Text files(*.txt)\n*.*|All files"), parent );

	if( url.isEmpty() ) return;

	QString fileName;
	bool blLocal = url.isLocalFile();
	if( blLocal ){
		fileName = url.path();
		conf->writeEntry( "StartDir", url.directory() );
	}else{
		if( !KIO::NetAccess::download( url, fileName, parent ) ){
			KMessageBox::sorry( parent, KIO::NetAccess::lastErrorString() );
			return;
		}
	}

	if( !fileName.isEmpty() ){
		Dixchange pd( fileName );
		for( Dixchange::iterator it = pd.begin(); it != pd.end(); ++it ){
			m_item.append( new WordItem( parent, (*it) ) );
		}
	}
	if( !blLocal ){
		KIO::NetAccess::removeTempFile( fileName );
	}
	m_succeed = true;
}


bool ImportDixchangeCommand::succeed()
{
	return m_succeed;
}

QString ImportDixchangeCommand::name() const
{
	return i18n( "Import Dixchange text dic" );
}

void ImportDixchangeCommand::execute()
{
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	m_parent->clearSelection();
	for( WordItem* item = m_item.first(); item; item=m_item.next() ){
		m_parent->insertItem( item );
		m_parent->setSelected( item, true );
	}
	m_parent->ensureItemVisible( m_item.at(m_item.count()-1) );
	QApplication::restoreOverrideCursor();
}

void ImportDixchangeCommand::unexecute()
{
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	m_parent->clearSelection();
	for( WordItem* item = m_item.first(); item; item=m_item.next() ){
		m_parent->takeItem( item );
	}
	QApplication::restoreOverrideCursor();
}

