/***************************************************************************
 *   Copyright (C) 2004 by  ͤ                                            *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MULTIEDITCOMMAND_H
#define MULTIEDITCOMMAND_H

#include "word.h"
#include "worditem.h"

#include <kcommand.h>
#include <qstring.h>
#include <klocale.h>
#include <kdebug.h>
#include <qptrlist.h>
#include <klistview.h>

class MultiEditCommand : public KCommand
{
public:
	MultiEditCommand( KListView* parent );
	void execute();
	void unexecute();
	QString name() const;
	bool succeed();
private:
	QValueList<Word> m_before, m_after;
	QPtrList<WordItem> m_item;
	bool m_succeed;
	KListView* m_parent;
};

#endif //MULTIEDITCOMMAND_H
