/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : main
 *
 * Copyright 2005,2007-2008 by M. Asselstine
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QPixmap>
#include <QString>
#include <QModelIndex>
#include <QStringList>
#include <QItemSelection>

#include <KXmlGuiWindow>

#include <kio/job.h>

class MainWindow : public KXmlGuiWindow
{
  Q_OBJECT

public:
  MainWindow(QWidget *parent=0);
  ~MainWindow();

public slots:
  void quit();

  void addPhotographs();
  void addPhotograph(const QString &filename);

  void commError(const QString &error);
  void doUserAuthentication(const QString &frob);
  void addUser(const QString &user, const QString &token, const QString &nsid);
  void setBandwidth(const QString &value);
  void setPhotosets(const QStringList& list, const QString& selection);
  void setLicenseTypes(const QStringList& list);
  void setTags(const QStringList &list);
  void updatePreview(int id);
  void selectionChanged(const QItemSelection& selected, const QItemSelection& deselected);
  void tableChanged(const QModelIndex& parent, int start, int end);
  void photoUploaded(const QString &photoID);
  void cancelUpload();

  void on_addUser_clicked();
  void on_removeUser_clicked();
  void on_addPhotos_clicked();
  void on_removePhotos_clicked();
  void on_userCombo_activated(const QString &user);
  void on_previous_clicked();
  void on_next_clicked();
  void on_uploadPhotos_clicked();

private:
  void setupActions();
  bool askAboutOldSession();
  void setActiveUser(const QString &user);
  void uploadNextPhoto();
  void showUploadDlg(int numBeingUploaded);
  void updateUploadDlg(const QPixmap &pixmap, KIO::TransferJob* job = 0L);
  void hideUploadDlg();

private:
  class PrivateData;
  PrivateData *d;
};
       
#endif // MAINWINDOW_H
