/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : main
 *
 * Copyright 2008 by M. Asselstine
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <QList>
#include <QSqlTableModel>

class SqlPhotoTableModel : public QSqlTableModel
{
  Q_OBJECT

public:
  SqlPhotoTableModel(QObject* parent = 0, QSqlDatabase db = QSqlDatabase());
  ~SqlPhotoTableModel();

  virtual QStringList mimeTypes() const;
  virtual Qt::DropActions supportedDropActions() const;
  virtual QMimeData* mimeData(const QModelIndexList& indexes) const;
  virtual Qt::ItemFlags flags(const QModelIndex& index) const;
  virtual bool dropMimeData(const QMimeData* data, Qt::DropAction action, int row,
			    int column, const QModelIndex& parent);

  int addPhotograph(const QString& filename, int at = -1, bool shuffle = true);
  void removePhotographs(QList<int> rows);

private:
  int getLargestId() const;
};
