/***************************************************************************
 *   Copyright (C) 2008 by Joerg Zopes   *
 *   joerg.zopes@linux-specialist.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef WIKILOOKUP_H
#define WIKILOOKUP_H

#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qprocess.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qfile.h>

/**
	@author Joerg Zopes <joerg.zopes@linux-specialist.com>
*/
class wikiLookup : public QDialog
{
Q_OBJECT
public:
    wikiLookup(QWidget *parent = 0, const char *name = 0,int mode = 0);
    ~wikiLookup();

private:
    QMultiLineEdit  * outputWindow;
    QProcess        * lsusbProcess;
    QPushButton     * cancelButton;
    QPushButton     * installButton;
    QPushButton     * searchButton;
    QLabel          * searchLabel;
    QLabel          * wikiLabel;
    QLineEdit       * searchEdit;
    QString           workingCards;
    QString           cardsFound;
    int               modus;
    void resizeEvent(QResizeEvent *);
private slots:
  void slot_lsusbProcessExited();
  void slot_installButtonClicked();
  void slot_cancelButtonClicked();
  void slot_searchButtonClicked();

};

#endif
