/***************************************************************************
 *   Copyright (C) 2008 by Joerg Zopes   *
 *   joerg.zopes@linux-specialist.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "kndiswrapper.h"
#include <qapplication.h>
#include <qfiledialog.h>
#include <qtextstream.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <setupdialog.h>
#include <stdlib.h>
#include <stdio.h>


int main(int argc, char **argv){
QString rc;
QString tf=(QString)getenv("HOME") + "/.kndiswrapper/setup.txt";

  QApplication app( argc, argv );

  if (argc > 1) rc=(QString)argv[1];

  if ((!QFile::exists(tf)) || (rc == "--setup")){
  	setupDialog * setup = new setupDialog(0,"setup");
	  setup->setModal(true);
	  setup->exec();
	  rc=setup->getResult();
	  if (rc != "") {
	    rc.replace("/usr/local/translations/kndiswrapper/","");
      system("mkdir " + (QString)getenv("HOME") + "/.kndiswrapper");
	    system("echo \"" + rc + "\" > " + tf);
	  }
  } else {
	  rc="";
	  QFile f(tf);
	  if (f.open(IO_ReadOnly)){
	    QTextStream stream(&f);
	    rc=stream.readLine();
	    f.close();
	  }
  }

  QTranslator translator( 0 );
  translator.load( rc, "/usr/local/translations/kndiswrapper" );
  app.installTranslator( &translator );

  kndiswrapper m;
  app.setMainWidget( &m );
  m.show();

  return app.exec();

}

