/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkapersonwidget.h"
#include "kkapersonaldata.h"

#include <qlabel.h>
#include <qlayout.h>

#include <kdebug.h>
#include <klocale.h>

using namespace KKAddressBook;

KKAPersonWidget::KKAPersonWidget( bool showLabel, QWidget* parent, const char* name )
	: QWidget( parent, name )
	, m_data( NULL )
{
	int iRow = ( showLabel ? 2 : 1 );
	QGridLayout* layout = new QGridLayout( this, iRow, 3 );
	if( showLabel )
	{
		QLabel* labels[3];
		labels[0] = new QLabel( i18n( "Prefix" ), this );
		labels[1] = new QLabel( i18n( "Full Name" ), this );
		labels[2] = new QLabel( i18n( "Suffix" ), this );

		for( int i = 0; i != 3; i++ )
		{
			layout->addWidget( labels[i], 0, i );
			labels[i]->setSizePolicy( QSizePolicy::Preferred, QSizePolicy::Fixed );
			labels[i]->setAlignment( AlignCenter );
			labels[i]->setFrameStyle( QLabel::Box );
			labels[i]->setFrameShadow( QLabel::Sunken );
		}
	}
	
	m_prefix = new KComboBox( this );
	m_prefix->setEditable( true );
	layout->addWidget( m_prefix, iRow - 1, 0 );
	m_name = new KLineEdit( this );
	layout->addWidget( m_name, iRow - 1, 1 );
	m_suffix = new KComboBox( this );
	m_suffix->setEditable( true );
	layout->addWidget( m_suffix, iRow - 1, 2 );

	QStringList list;
	list = QStringList::split( QString( " " ), i18n( "Dr. Mr. Miss. Mrs. Ms. Prof." ) );
	list.push_front( "" );
	m_prefix->insertStringList( list );
	list = QStringList::split( QString( " " ), i18n( "I II III Jr. Sr." ) );
	list.push_front( "" );
	m_suffix->insertStringList( list );

	layout->setColStretch( 0, 1 );
	layout->setColStretch( 1, 5 );
	layout->setColStretch( 2, 1 );

	connect( m_name, SIGNAL( textChanged( const QString& ) ), this, SIGNAL( nameChanged( const QString& ) ) );

	setSizePolicy( QSizePolicy::Preferred, QSizePolicy::Fixed );
}


KKAPersonWidget::~KKAPersonWidget()
{
}

void KKAPersonWidget::setData( KKAPersonalData* data )
{
	if( m_data == data ) return;
	if( m_data )
	{
		disconnect( m_prefix, SIGNAL( textChanged( const QString& ) ), m_data, SLOT( setPrefix( const QString& ) ) );
		disconnect( m_name, SIGNAL( textChanged( const QString& ) ), m_data, SLOT( setName( const QString& ) ) );
		disconnect( m_suffix, SIGNAL( textChanged( const QString& ) ), m_data, SLOT( setSuffix( const QString& ) ) );
	}
	m_data = data;
	if( m_data )
	{
		m_prefix->setCurrentText( m_data->prefix() );
		m_name->setText( m_data->name() );
		m_suffix->setCurrentText( m_data->suffix() );
		connect( m_prefix, SIGNAL( textChanged( const QString& ) ), m_data, SLOT( setPrefix( const QString& ) ) );
		connect( m_name, SIGNAL( textChanged( const QString& ) ), m_data, SLOT( setName( const QString& ) ) );
		connect( m_suffix, SIGNAL( textChanged( const QString& ) ), m_data, SLOT( setSuffix( const QString& ) ) );
	}
	else
	{
		m_prefix->setCurrentText( "" );
		m_name->setText( "" );
		m_suffix->setCurrentText( "" );
	}
}
