/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKDSIZEHANDLER_H_
#define _KKDSIZEHANDLER_H_

#include <qwidget.h>

namespace KKDesigner
{
	class KKDItemBase;
	class KKDSizeHandlerWidget;

	class KKDSizeHandler : public QObject
	{
		Q_OBJECT
	public:
		KKDSizeHandler( QWidget* parent, KKDItemBase* item );
		~KKDSizeHandler();

	signals:
		void repaint( const QRect& );
		void start();
		void resizing();
		void end();

	public slots:
		void setVisible();
		void setGeometry();

	private:
		KKDItemBase* m_item;
		KKDSizeHandlerWidget* m_sh[3][3];

		void resize( int x, int y, int w, int h, int ax, int ay );

	private slots:
		void resize( int x, int y, QPoint p );
	};
}

#endif /* _KKDSIZEHANDLER_H_ */
