/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qradiobutton.h>

#include "DlgCleanCache.h"


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

DlgCleanCache::DlgCleanCache(QWidget * pParent)
  : BaseDlgCleanCache(pParent, "DlgCleanCache")
{
    // Default is "clean all"
    enableSelection(false);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgCleanCache::enableSelection(bool bEnable)
{
    m_pCheckHeaders->setEnabled(bEnable);
    m_pCheckPackages->setEnabled(bEnable);
    m_pCheckMetadata->setEnabled(bEnable);
    m_pCheckCache->setEnabled(bEnable);
    m_pCheckDBCache->setEnabled(bEnable);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgCleanCache::slotRadioAllStateChanged(int state)
{
    enableSelection(QRadioButton::On != state);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

int DlgCleanCache::cleanWhich() const
{
    int which = 0;

    if ( m_pRadioAll->isChecked() )
    {
        which = c_cleanAll;
    }
    else
    {
        if ( m_pCheckHeaders->isChecked() )
            which |= c_cleanHeaders;

        if ( m_pCheckPackages->isChecked() )
            which |= c_cleanPackages;

        if ( m_pCheckMetadata->isChecked() )
            which |= c_cleanMetadata;

        if ( m_pCheckCache->isChecked() )
            which |= c_cleanCache;

        if ( m_pCheckDBCache->isChecked() )
            which |= c_cleanDBCache;
    }

    return which;
}

#include "DlgCleanCache.moc"
