/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef PackageInfo_H_Included
#define PackageInfo_H_Included

#include <list>

#include <qstring.h>

#include "AutoPtr.h"


struct PackageInfo
  {
    typedef AutoPtr<PackageInfo>  Ptr;
    typedef std::list<Ptr>        List;

    QString     m_strName,
                m_strVersion,
                m_strInstalledVer,
                m_strArch,
                m_strRepoTag,
                m_strDescription,
                m_strSummary,
                m_strSize;
    bool        m_bChecked,
                m_bInstalling;

                PackageInfo(QString strName = "",
                            QString strArch = "",
                            QString strVer  = "")
                {
                    m_strName     = strName;
                    m_strArch     = strArch;
                    m_strVersion  = strVer;
                    m_bChecked    = false;
                    m_bInstalling = false;
                }

    bool        getFromLine(QString strLine);

    QString     getMapKey() const
                {
                    return m_strName + '.' + m_strArch;
                }

    QString     getNameAndVersion()
                {
                    return m_strName + '-' + m_strVersion;
                }

    double      getPkgSize() const;

    bool        isValid() const
                {
                    return !m_strName.isEmpty()
                              && !m_strVersion.isEmpty()
                              && !m_strArch.isEmpty()
                              && !m_strRepoTag.isEmpty()
                              && m_strVersion[0].isDigit();
                }
  };

#endif

