/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChartFormatRecord
extends Record {
    public static final short sid = 4116;
    private int field1_x_position;
    private int field2_y_position;
    private int field3_width;
    private int field4_height;
    private short field5_grbit;
    private BitField varyDisplayPattern;

    protected void validateSid(short id) {
        if (id != 4116) {
            throw new RecordFormatException("NOT A CHARTFORMAT RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field1_x_position = in.readInt();
        this.field2_y_position = in.readInt();
        this.field3_width = in.readInt();
        this.field4_height = in.readInt();
        this.field5_grbit = in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CHARTFORMAT]\n");
        buffer.append("    .xPosition       = ").append(this.getXPosition()).append("\n");
        buffer.append("    .yPosition       = ").append(this.getYPosition()).append("\n");
        buffer.append("    .width           = ").append(this.getWidth()).append("\n");
        buffer.append("    .height          = ").append(this.getHeight()).append("\n");
        buffer.append("    .grBit           = ").append(Integer.toHexString(this.field5_grbit)).append("\n");
        buffer.append("[/CHARTFORMAT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, offset, (short)4116);
        LittleEndian.putShort(data, 2 + offset, (short)22);
        LittleEndian.putInt(data, 4 + offset, this.getXPosition());
        LittleEndian.putInt(data, 8 + offset, this.getYPosition());
        LittleEndian.putInt(data, 12 + offset, this.getWidth());
        LittleEndian.putInt(data, 16 + offset, this.getHeight());
        LittleEndian.putShort(data, 20 + offset, this.field5_grbit);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 22;
    }

    public short getSid() {
        return 4116;
    }

    public int getXPosition() {
        return this.field1_x_position;
    }

    public void setXPosition(int xPosition) {
        this.field1_x_position = xPosition;
    }

    public int getYPosition() {
        return this.field2_y_position;
    }

    public void setYPosition(int yPosition) {
        this.field2_y_position = yPosition;
    }

    public int getWidth() {
        return this.field3_width;
    }

    public void setWidth(int width) {
        this.field3_width = width;
    }

    public int getHeight() {
        return this.field4_height;
    }

    public void setHeight(int height) {
        this.field4_height = height;
    }

    public boolean getVaryDisplayPattern() {
        return this.varyDisplayPattern.isSet(this.field5_grbit);
    }

    public void setVaryDisplayPattern(boolean value) {
        this.field5_grbit = this.varyDisplayPattern.setShortBoolean(this.field5_grbit, value);
    }

    private final /* synthetic */ void this() {
        this.varyDisplayPattern = BitFieldFactory.getInstance(1);
    }

    public ChartFormatRecord() {
        this.this();
    }

    public ChartFormatRecord(RecordInputStream in) {
        super(in);
        this.this();
    }
}

