/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.List;
import java.util.Stack;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FormulaRecord
extends Record
implements CellValueRecordInterface,
Comparable {
    public static final short sid = 6;
    private int field_1_row;
    private short field_2_column;
    private short field_3_xf;
    private double field_4_value;
    private short field_5_options;
    private BitField alwaysCalc;
    private BitField calcOnLoad;
    private BitField sharedFormula;
    private int field_6_zero;
    private short field_7_expression_len;
    private Stack field_8_parsed_expr;
    private byte[] value_data;
    private byte[] all_data;

    protected void fillFields(RecordInputStream in) {
        try {
            this.field_1_row = in.readUShort();
            this.field_2_column = in.readShort();
            this.field_3_xf = in.readShort();
            this.field_4_value = in.readDouble();
            this.field_5_options = in.readShort();
            if (Double.isNaN(this.field_4_value)) {
                this.value_data = in.getNANData();
            }
            this.field_6_zero = in.readInt();
            this.field_7_expression_len = in.readShort();
            this.field_8_parsed_expr = Ptg.createParsedExpressionTokens(this.field_7_expression_len, in);
        }
        catch (UnsupportedOperationException uoe) {
            throw new RecordFormatException(uoe);
        }
    }

    public void setRow(int row) {
        this.field_1_row = row;
    }

    public void setColumn(short column) {
        this.field_2_column = column;
    }

    public void setXFIndex(short xf) {
        this.field_3_xf = xf;
    }

    public void setValue(double value) {
        this.field_4_value = value;
    }

    public void setOptions(short options) {
        this.field_5_options = options;
    }

    public void setExpressionLength(short len) {
        this.field_7_expression_len = len;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_column;
    }

    public short getXFIndex() {
        return this.field_3_xf;
    }

    public double getValue() {
        return this.field_4_value;
    }

    public short getOptions() {
        return this.field_5_options;
    }

    public boolean isSharedFormula() {
        return this.sharedFormula.isSet(this.field_5_options);
    }

    public void setSharedFormula(boolean flag) {
        this.sharedFormula.setBoolean(this.field_5_options, flag);
    }

    public short getExpressionLength() {
        return this.field_7_expression_len;
    }

    public void pushExpressionToken(Ptg ptg) {
        this.field_8_parsed_expr.push(ptg);
    }

    public Ptg popExpressionToken() {
        return (Ptg)this.field_8_parsed_expr.pop();
    }

    public Ptg peekExpressionToken() {
        return (Ptg)this.field_8_parsed_expr.peek();
    }

    public int getNumberOfExpressionTokens() {
        if (this.field_8_parsed_expr == null) {
            return 0;
        }
        return this.field_8_parsed_expr.size();
    }

    public List getParsedExpression() {
        return this.field_8_parsed_expr;
    }

    public void setParsedExpression(Stack ptgs) {
        this.field_8_parsed_expr = ptgs;
    }

    protected void validateSid(short id) {
        if (id != 6) {
            throw new RecordFormatException("NOT A FORMULA RECORD");
        }
    }

    public short getSid() {
        return 6;
    }

    public int serialize(int offset, byte[] data) {
        if (this.field_8_parsed_expr != null) {
            int ptgSize = this.getTotalPtgSize();
            LittleEndian.putShort(data, offset, (short)6);
            LittleEndian.putShort(data, 2 + offset, (short)(22 + ptgSize));
            LittleEndian.putShort(data, 4 + offset, (short)this.getRow());
            LittleEndian.putShort(data, 6 + offset, this.getColumn());
            LittleEndian.putShort(data, 8 + offset, this.getXFIndex());
            if (Double.isNaN(this.getValue()) && this.value_data != null) {
                System.arraycopy(this.value_data, 0, data, 10 + offset, this.value_data.length);
            } else {
                LittleEndian.putDouble(data, 10 + offset, this.field_4_value);
            }
            LittleEndian.putShort(data, 18 + offset, this.getOptions());
            LittleEndian.putInt(data, 20 + offset, 0);
            LittleEndian.putShort(data, 24 + offset, this.getExpressionLength());
            Ptg.serializePtgStack(this.field_8_parsed_expr, data, 26 + offset);
        } else {
            System.arraycopy(this.all_data, 0, data, offset, this.all_data.length);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int retval = 0;
        retval = this.field_8_parsed_expr != null ? this.getTotalPtgSize() + 26 : this.all_data.length;
        return retval;
    }

    private final int getTotalPtgSize() {
        List list = this.getParsedExpression();
        int retval = 0;
        int k = 0;
        while (k < list.size()) {
            Ptg ptg = (Ptg)list.get(k);
            retval += ptg.getSize();
            ++k;
        }
        return retval;
    }

    public boolean isBefore(CellValueRecordInterface i) {
        if (this.getRow() > i.getRow()) {
            return false;
        }
        if (this.getRow() == i.getRow() && this.getColumn() > i.getColumn()) {
            return false;
        }
        return this.getRow() != i.getRow() || this.getColumn() != i.getColumn();
    }

    public boolean isAfter(CellValueRecordInterface i) {
        if (this.getRow() < i.getRow()) {
            return false;
        }
        if (this.getRow() == i.getRow() && this.getColumn() < i.getColumn()) {
            return false;
        }
        return this.getRow() != i.getRow() || this.getColumn() != i.getColumn();
    }

    public boolean isEqual(CellValueRecordInterface i) {
        boolean bl = false;
        if (this.getRow() == i.getRow() && this.getColumn() == i.getColumn()) {
            bl = true;
        }
        return bl;
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public int compareTo(Object obj) {
        CellValueRecordInterface loc = (CellValueRecordInterface)obj;
        if (this.getRow() == loc.getRow() && this.getColumn() == loc.getColumn()) {
            return 0;
        }
        if (this.getRow() < loc.getRow()) {
            return -1;
        }
        if (this.getRow() > loc.getRow()) {
            return 1;
        }
        if (this.getColumn() < loc.getColumn()) {
            return -1;
        }
        if (this.getColumn() > loc.getColumn()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CellValueRecordInterface)) {
            return false;
        }
        CellValueRecordInterface loc = (CellValueRecordInterface)obj;
        return this.getRow() == loc.getRow() && this.getColumn() == loc.getColumn();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FORMULA]\n");
        buffer.append("    .row       = ").append(Integer.toHexString(this.getRow())).append("\n");
        buffer.append("    .column    = ").append(Integer.toHexString(this.getColumn())).append("\n");
        buffer.append("    .xf              = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        if (Double.isNaN(this.getValue()) && this.value_data != null) {
            buffer.append("    .value (NaN)     = ").append(HexDump.dump(this.value_data, 0L, 0)).append("\n");
        } else {
            buffer.append("    .value           = ").append(this.getValue()).append("\n");
        }
        buffer.append("    .options         = ").append(this.getOptions()).append("\n");
        buffer.append("      .alwaysCalc         = ").append(this.alwaysCalc.isSet(this.getOptions())).append("\n");
        buffer.append("      .calcOnLoad         = ").append(this.calcOnLoad.isSet(this.getOptions())).append("\n");
        buffer.append("      .sharedFormula         = ").append(this.sharedFormula.isSet(this.getOptions())).append("\n");
        buffer.append("    .zero            = ").append(this.field_6_zero).append("\n");
        buffer.append("    .expressionlength= ").append(this.getExpressionLength()).append("\n");
        if (this.field_8_parsed_expr != null) {
            buffer.append("    .numptgsinarray  = ").append(this.field_8_parsed_expr.size()).append("\n");
            int k = 0;
            while (k < this.field_8_parsed_expr.size()) {
                buffer.append("     Ptg(").append(k).append(")=").append(this.field_8_parsed_expr.get(k).toString()).append("\n").append(((Ptg)this.field_8_parsed_expr.get(k)).toDebugString()).append("\n");
                ++k;
            }
        } else {
            buffer.append("Formula full data \n").append(HexDump.dump(this.all_data, 0L, 0));
        }
        buffer.append("[/FORMULA]\n");
        return buffer.toString();
    }

    public Object clone() {
        FormulaRecord rec = new FormulaRecord();
        rec.field_1_row = this.field_1_row;
        rec.field_2_column = this.field_2_column;
        rec.field_3_xf = this.field_3_xf;
        rec.field_4_value = this.field_4_value;
        rec.field_5_options = this.field_5_options;
        rec.field_6_zero = this.field_6_zero;
        rec.field_7_expression_len = this.field_7_expression_len;
        rec.field_8_parsed_expr = new Stack();
        int size = 0;
        if (this.field_8_parsed_expr != null) {
            size = this.field_8_parsed_expr.size();
        }
        int i = 0;
        while (i < size) {
            Ptg ptg = (Ptg)((Ptg)this.field_8_parsed_expr.get(i)).clone();
            rec.field_8_parsed_expr.add(i, ptg);
            ++i;
        }
        rec.value_data = this.value_data;
        rec.all_data = this.all_data;
        return rec;
    }

    private final /* synthetic */ void this() {
        this.alwaysCalc = BitFieldFactory.getInstance(1);
        this.calcOnLoad = BitFieldFactory.getInstance(2);
        this.sharedFormula = BitFieldFactory.getInstance(8);
    }

    public FormulaRecord() {
        this.this();
        this.field_8_parsed_expr = new Stack();
    }

    public FormulaRecord(RecordInputStream in) {
        super(in);
        this.this();
    }
}

