/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class PrintGridlinesRecord
extends Record {
    public static final short sid = 43;
    private short field_1_print_gridlines;

    protected void validateSid(short id) {
        if (id != 43) {
            throw new RecordFormatException("NOT A PrintGridlines RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_print_gridlines = in.readShort();
    }

    public void setPrintGridlines(boolean pg) {
        this.field_1_print_gridlines = pg ? (short)1 : 0;
    }

    public boolean getPrintGridlines() {
        boolean bl = false;
        if (this.field_1_print_gridlines == 1) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PRINTGRIDLINES]\n");
        buffer.append("    .printgridlines = ").append(this.getPrintGridlines()).append("\n");
        buffer.append("[/PRINTGRIDLINES]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, offset, (short)43);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_print_gridlines);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 43;
    }

    public Object clone() {
        PrintGridlinesRecord rec = new PrintGridlinesRecord();
        rec.field_1_print_gridlines = this.field_1_print_gridlines;
        return rec;
    }

    public PrintGridlinesRecord() {
    }

    public PrintGridlinesRecord(RecordInputStream in) {
        super(in);
    }
}

