/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class WindowProtectRecord
extends Record {
    public static final short sid = 25;
    private short field_1_protect;

    protected void validateSid(short id) {
        if (id != 25) {
            throw new RecordFormatException("NOT A WINDOWPROTECT RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_protect = in.readShort();
    }

    public void setProtect(boolean protect) {
        this.field_1_protect = protect ? (short)1 : 0;
    }

    public boolean getProtect() {
        boolean bl = false;
        if (this.field_1_protect == 1) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[WINDOWPROTECT]\n");
        buffer.append("    .protect         = ").append(this.getProtect()).append("\n");
        buffer.append("[/WINDOWPROTECT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, offset, (short)25);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_protect);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 25;
    }

    public WindowProtectRecord() {
    }

    public WindowProtectRecord(RecordInputStream in) {
        super(in);
    }
}

