/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.base.util.Empty;

public class AttributeMap
implements Serializable,
Cloneable {
    private static final String[] EMPTY_NAMESPACES = new String[0];
    private static final long serialVersionUID = -7442871030874215436L;
    private HashMap namespaces;

    public AttributeMap() {
    }

    public AttributeMap(AttributeMap copy) {
        if (copy == null) {
            return;
        }
        if (copy.namespaces == null) {
            return;
        }
        this.namespaces = (HashMap)copy.namespaces.clone();
        for (Map.Entry entry : this.namespaces.entrySet()) {
            HashMap value = (HashMap)entry.getValue();
            entry.setValue(value.clone());
        }
    }

    public Object clone() {
        try {
            AttributeMap map = (AttributeMap)super.clone();
            if (this.namespaces != null) {
                map.namespaces = (HashMap)this.namespaces.clone();
                for (Map.Entry entry : map.namespaces.entrySet()) {
                    HashMap value = (HashMap)entry.getValue();
                    entry.setValue(value.clone());
                }
            }
            return map;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Cannot happen: Clone not supported exception");
        }
    }

    public Object setAttribute(String namespace, String attribute, Object value) {
        HashMap attrs;
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (attribute == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if ((attrs = (HashMap)this.namespaces.get(namespace)) == null) {
            if (value == null) {
                return null;
            }
            HashMap<String, Object> newAtts = new HashMap<String, Object>();
            newAtts.put(attribute, value);
            this.namespaces.put(namespace, newAtts);
            return null;
        }
        if (value == null) {
            Object retval = attrs.remove(attribute);
            if (attrs.isEmpty()) {
                this.namespaces.remove(namespace);
            }
            return retval;
        }
        return attrs.put(attribute, value);
    }

    public Object getAttribute(String namespace, String attribute) {
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (attribute == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.namespaces == null) {
            return null;
        }
        HashMap attrs = (HashMap)this.namespaces.get(namespace);
        if (attrs == null) {
            return null;
        }
        return attrs.get(attribute);
    }

    public Object getFirstAttribute(String attribute) {
        if (attribute == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.namespaces == null) {
            return null;
        }
        for (Map.Entry entry : this.namespaces.entrySet()) {
            HashMap map = (HashMap)entry.getValue();
            Object val = map.get(attribute);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    public Map getAttributes(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (this.namespaces == null) {
            return Empty.MAP;
        }
        HashMap attrs = (HashMap)this.namespaces.get(namespace);
        if (attrs == null) {
            return Empty.MAP;
        }
        return Collections.unmodifiableMap(attrs);
    }

    public String[] getNames(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (this.namespaces == null) {
            return EMPTY_NAMESPACES;
        }
        HashMap attrs = (HashMap)this.namespaces.get(namespace);
        if (attrs == null) {
            return EMPTY_NAMESPACES;
        }
        return attrs.keySet().toArray(new String[attrs.size()]);
    }

    public String[] getNameSpaces() {
        if (this.namespaces == null) {
            return EMPTY_NAMESPACES;
        }
        return this.namespaces.keySet().toArray(new String[this.namespaces.size()]);
    }
}

