.\" Man page for man (and the former manpath)
.\"
.\" Copyright (c) 1990, 1991, John W. Eaton.
.\" Traduction franaise Ren Cougnenc - Mai 1995 
.\" Mise  jour importante Alain Portal le 2 juin 2005
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the README file that comes with the man 1.0
.\" distribution.  
.\"
.\" John W. Eaton
.\" jwe@che.utexas.edu
.\" Department of Chemical Engineering
.\" The University of Texas at Austin
.\" Austin, Texas  78712
.\"
.\" Many changes - aeb
.\" More changes - flc
.\"
.TH MAN 1 "19 septembre 2005" "Manuel Linux" "Commandes utilisateur"
.LO 1
.SH NOM
man \- formate et affiche les pages du manuel en ligne
.SH SYNOPSIS
.B man 
.RB [ \-acdfFhkKtwW ]
.RB [ --path ]
.RB [ \-m
.IR systme ]
.RB [ \-p
.IR chane ]
.RB [ \-C
.IR fichier_config ]
.RB [ \-M
.IR chemin ]
.RB [ \-P
.IR visualiseur ]
.RB [ \-B
.IR navigateur ]
.RB [ \-H
.IR visualiseur_html ]
.RB [ \-S
.IR liste_sections ]
.RI [ section ]
.I "nom ..."

.SH DESCRIPTION
.B man
formate et affiche les pages du manuel en ligne. Si
.I section
est spcifie,
.B man
ne recherchera que dans cette section du manuel.
.I nom
est le nom de la page qui est gnralement le nom d'une commande,
d'une fonction ou d'un fichier. Toutefois, si
.I nom
contient une barre oblique
.RB " \ "/ \ ,
il sera d'abord considr en tant que nom de fichier, vous pouvez donc faire\ :
.B "man ./toto.5"
ou mme
.B "man /truc/machin/bidule.1.gz\fR.\fP"
.PP
Voir plus loin pour une description sur la faon dont
.B man
cherche les fichiers pages de manuel.
 
.SH OPTIONS
.TP
.B \-\^C " fichier_config"
Spcifie le fichier de configuration  utiliser\ ; par dfaut il s'agit de
.BR @man_config_file@ .
(Voir
.BR man.conf (5).)
.TP
.B \-\^M " chemin"
Indique la liste des rpertoires dans lesquels la recherche des pages 
sera effectue. Veuillez sparer les rpertoires par le symbole deux points
.RB " \ ": \ .
Une liste vide est quivalent  ne pas spcifier l'option
.BR \-M .
Voir
.BR "CHEMIN DE RECHERCHE POUR LES PAGES DE MANUEL" .
.TP
.B \-\^P " visualiseur"
Indique le programme de visualisation des pages  employer.
Cette option a priorit sur la variable d'environnement
.BR MANPAGER ,
qui,  son tour, a priorit sur la variable d'environnement
.BR PAGER .
Par dfaut,
.B man 
utilisera
.B @pager@.
.TP
.B \-\^B
Spcifie quel navigateur utiliser pour les fichiers HTML.
Cette option supplante la variable d'environnement
.B BROWSER
Par dfaut,
.B man
utilise
.BR @browser@ .
.TP
.B \-\^H
Spcifie une commande qui produit un fichier texte  partir du fichier HTML.
Cette option supplante la variable d'environnement
.B HTMLPAGER
Par dfaut,
.B man
utilise
.BR @htmlpager@ .
.TP
.B \-\^S " liste_sections"
Il s'agit d'une liste de sections, spares par le symbole deux points
.RB " \ ": \ ,
dans lesquelles les pages seront recherches. Elle a priorit sur
la variable d'environnement
.B MANSECT.
.TP
.B \-\^a
Par dfaut,
.B man 
s'arrte aprs avoir affich la premire page de
manuel trouve. Cette option permet de l'obliger  afficher toutes
les pages correspondant  la requte
.RB " \ "nom \ 
de l'utilisateur, s'il y en a plusieurs, et pas seulement la premire trouve.
.TP
.B \-\^c
Reformater la page de manuel, mme si une version prformate  jour
existe. Cela peut tre utile si cette dernire a t prvue pour un
cran de taille diffrente ou bien si elle est abme.
.TP
.B \-\^d
Ne pas afficher les pages de manuel, mais fournir une grande quantit
d'informations de dbogage.
.TP
.B \-\^D
Afficher  la fois les pages de manuel et les informations de dbogage.
.TP
.B \-\^f
quivalent 
.BR whatis .
.TP
.B \-\^h
Afficher un court message d'aide et quitter.
.TP
.B \-\^k
quivalent 
.B apropos.
.TP
.B \-\^K
Chercher la chane spcifie dans *toutes* les pages de manuel. Attention\ :
cela peut tre trs long\ ! Et il peut tre utile de spcifier une section.
(Pour donner une vague ide, sur ma machine, il faut environ une minute
pour 500 pages de manuel.)
.TP
.B \-\^m " systme"
Demander l'utilisation d'un autre jeu de pages de manuel, en fonction
du nom de systme indiqu.
.TP
.B \-\^p " chane"
Spcifie la squence de prprocesseurs  excuter avant
.B nroff
ou
.BR troff .
Selon votre installation de Linux, vous ne disposerez pas forcment
de tous les programmes possibles. Voici les  plus courants et les lettres
qui les dsignent\ :
eqn (e), grap (g), pic (p), tbl (t), vgrind (v), refer (r).
Cette option a priorit sur la variable d'environnement
.B MANROFFSEQ.
.TP
.B \-\^t
Utiliser
.B @troff@
pour formater la page de manuel, la sortie se faisant sur
.B stdout.
La sortie de 
.B @troff@
peut ncessiter un passage par certains filtres avant de pouvoir
tre affiche ou imprime.
.TP
.B \-\^w \fRou\fP \-\-path
Ne pas afficher les pages de manuel, mais les emplacements des fichiers
qui auraient t formats ou affichs. Si aucun argument n'est prcis,
indique sur la sortie standard la liste des rpertoires dans lesquels
.B man
recherche les pages. Si
.B manpath
est un lien sur le programme man, alors \ manpath\  est quivalent
 la commande \ man --path\ .
.TP
.B \-\^W
Comme \-\^w, mais affiche les noms de fichiers, un par ligne, sans aucune
autre information. Trs utile dans des commandes shell du genre\ :
.ft CW
.B man -aW man | xargs ls -l
.ft

.SH "PAGES FORMATES"
Afin de gagner du temps, 
.B man 
tente de sauvegarder les pages formates
au lieu de les interprter chaque fois qu'elles sont demandes.
Traditionnellement, les versions formates des pages de REP/manX sont
enregistres dans REP/catX, mais d'autres correspondances entre les
rpertoires man et les rpertoires cat peuvent tre indiques dans
le fichier
.BR @man_config_file@ .
Aucune page formate n'est enregistre si le rpertoire \ cat\  correspondant
n'existe pas.
Aucune page formate n'est enregistre si elle est formate avec une longueur
de ligne diffrente de 80.
Aucune page formate n'est enregistre si le fichier
.B @man_config_file@
contient la ligne NOCACHE.
.PP
Il est possible de rendre
.B man
suid utilisateur man. Dans ce cas, si un rpertoire \ cat\  appartient
 man et a le mode 0755 (seul man peut l'crire), et que les fichiers
formats appartiennent eux aussi  man et ont le mode 0644 ou 0444 (seul
man peut les crire, voire personne), aucun utilisateur normal ne pourra
modifier les pages formates ou mettre d'autre fichiers dans le rpertoire
correspondant. Si
.B man
n'est pas suid, les rpertoires  cat  devront avoir le mode 0777 afin
que tout utilisateur puisse y laisser le rsultat des formatages lors
des consultations du manuel.
.PP
L'option
.B \-c
force le reformatage d'une page, mme si un fichier cat
plus rcent que le fichier source existe.

.SH "CHEMIN DE RECHERCHE POUR LES PAGES DE MANUEL"
.B man
utilise une mthode sophistique pour chercher les pages de manuels,
base sur l'invocation d'options et de variables d'environnement,
le fichier de configuration
.BR @man_config_file@ ,
des heuristiques et conventions prdfinies.
.PP
En premier lieu, lorsque l'argument
.I nom
de
.B man
contient une barre oblique
.RB " \ "/ \ ,
.B man
suppose qu'il s'agit d'un fichier et aucune recherche complexe n'est lance.
.PP
Mais dans la plupart des cas o
.I nom
ne contient pas de barre oblique,
.B man
recherche dans plusieurs rpertoires un fichier qui pourrait tre une page
de manuel pour le sujet nomm.
.PP
Si vous spcifiez l'option
.B \-M
.IR liste_chemins ,
.I liste_chemins
est une liste de rpertoires, spars par le symbole deux points 
.RB " \ ": \ ,
dans lesquels
.B man
effectuera sa recherche.
.PP
Si vous ne spcifiez pas
.B -M
mais que vous positionniez la variable d'environnement
.BR MANPATH ,
la valeur de cette variable est la liste des rpertoires dans lesquels
.B man
effectuera sa recherche.
.PP
Si vous ne spcifiez pas une liste de chemins explicite avec
.B -M
ou 
.BR MANPATH ,
.B man
dveloppe sa propre liste de chemins base sur le contenu du fichier de
configuration 
.BR @man_config_file@ .
Les dclarations
.B MANPATH
dans le fichier de configuration identifient des rpertoires particuliers
 inclure dans le chemin de recherche.
.PP
Qui plus est, les dclarations
.B MANPATH_MAP
compltent le chemin de recherche en fonction du chemin de recherche de vos
commandes (autrement dit, de votre variable d'environnement
.BR PATH ).
La dclaration
.B MANPATH_MAP
indique, pour chacun des rpertoires pouvant se trouver dans le chemin de
recherche des commandes, un rpertoire qui devrait tre ajout au chemin de
recherche des pages de manuel.
.B man
scrute la variable
.B PATH
et ajoute au chemin de recherche des pages de manuel les rpertoires
correspondants. Ainsi, avec une utilisation correcte de
.BR MANPATH_MAP ,
lorsque vous tapez la commande
.BR "man xyz" ,
vous obtenez la page de manuel du programme que vous lanceriez si vous
tapiez la commande
.BR xyz .
.PP
De plus, pour chacun des rpertoires situs dans le chemin de recherche des
commandes (nous l'appellerons \ rpertoire commandes\ ) pour lequel vous
.IR n "'avez " pas
d'instruction
.BR MANPATH_MAP ,
.B man
cherchera automatiquement un rpertoire de pages de manuel  proximit,
 savoir un sous-rpertoire du \ rpertoire commandes\  lui-mme ou dans
le rpertoire parent du \ rpertoire commandes\ .
.PP
Vous pouvez dsactiver la recherche automatique de proximit en incluant
l'instruction
.B NOAUTOPATH
dans le fichier de configuration
.BR @man_config_file@ .
.PP
Dans chaque rpertoire du chemin de recherche dcrit plus haut,
.B man
cherche un fichier nomm
.IB sujet . section\fR,
avec un suffixe optionnel sur le numro de section et un possible suffixe
de compression. S'il ne peut trouver un tel fichier, il regarde alors dans
tous les sous-rpertoires nomms
.BI man N
ou
.BI cat N
o
.I N
est le numro de la section du manuel. Si le fichier se trouve dans
le sous-rpertoire
.B cat
.IR N ,
.B man
suppose qu'il s'agit d'une page de manuel formate (page cat). Autrement,
.B man
suppose qu'elle n'est pas formate. Dans tous les cas, si le nom de
fichier comporte une extension indiquant une compression connue (comme
.BR .gz ),
.B man
suppose que le fichier est gzipp.
.PP
Si vous vouloir savoir o (ou si)
.B man
peut trouver une page de manuel sur un sujet particulier, utilisez l'option
.BR "--path " ( -w ).

.SH ENVIRONNEMENT
.TP
.B MANPATH
Si la variable
.B MANPATH
est positionne,
.B man
utilisera sa valeur comme chemin de recherche des pages de manuel.
Cette variable est prioritaire sur le fichier de configuration et le chemin
de recherche automatique, mais cde cette priorit si l'option
.B -M
est utilise. Voir
.BR "CHEMIN DE RECHERCHE POUR LES PAGES DE MANUEL" .
.TP
.B MANPL
Si la variable
.B MANPL
est positionne, sa valeur servira  dfinir la longueur de l'affichage de la
page. Autrement, la page entire est affiche sur une seule et longue page.
.TP
.B MANROFFSEQ
Si
.B MANROFFSEQ
est positionne, sa valeur servira  dterminer le jeu de prprocesseurs
 excuter avant de lancer
.B nroff
ou
.BR troff .
Par dfaut, les pages sont passes dans le processeur de tableaux avant
.BR nroff .
.TP
.B MANSECT
Si
.B MANSECT
est positionne, sa valeur dterminera les sections du manuel dans
lesquelles les pages seront recherches.
.TP
.B MANWIDTH
Si
.B MANWIDTH
est positionne, sa valeur servira  dfinir la largeur de l'affichage de la
page. Autrement, la page sera affiche sur toute la largeur de l'cran.
.TP
.B MANPAGER
Si
.B MANPAGER
est positionne, sa valeur sera considre comme le nom du programme
 utiliser pour visualiser la page de manuel. Dans le cas contraire,
.B PAGER
sera utilise. Si aucune des deux variables n'est positionne,
.B @pager@
sera utilis.
.TP
.B LANG
Si
.B LANG
est positionne, sa valeur dfinira le nom du sous-rpertoire o
.B man
commencera la recherche des pages de manuel. Ainsi, la commande
\ LANG=fr man 1 toto\  aura pour effet de faire rechercher la page
toto dans .../fr/man1/toto.1, et si ce fichier n'existe pas, 
dans .../man1/toto.1, o ... est un rpertoire du chemin de recherche.
.TP
.B "NLSPATH, LC_MESSAGES, LANG"
Les variables d'environnement
.B NLSPATH
et
.B LC_MESSAGES
(ou
.B LANG
lorsque la dernire n'existe pas)
jouent un rle dans la localisation du catalogue de messages.
(Mais les messages anglais sont inclus dans le programme  la compilation,
aucun catalogue n'est donc ncessaire pour un affichage dans la langue de
Shakespeare.)
Notez que les programmes comme
.BR col (1)
qui sont appels par 
.BR man ,
utilisent galement LC_CTYPE.
.TP
.B PATH
.B PATH
est utilise pour la construction du chemin de recherche par dfaut. Voir
.BR "CHEMIN DE RECHERCHE POUR LES PAGES DE MANUEL" .
.TP
.B SYSTEM
.B SYSTEM
est employe pour obtenir le nom du systme alternatif par dfaut (en vue de
l'utilisation de l'option 
.B \-m
). 
.SH BOGUES
L'option
.B \-t
ne fonctionne que si un programme \ troff-like\  est install.
.br
Si vous voyez clignoter \e255 ou <AD> au lieu de traits d'union,
mettez \ LESSCHARSET=latin1\  dans votre environnement.
.SH ASTUCES
Si vous ajoutez la ligne

  (global-set-key [(f1)] (lambda () (interactive) (manual-entry (current-word))))

 votre fichier
.IR .emacs ,
vous obtiendrez la page de manuel de l'appel de la bibliothque situ  la
position courante du curseur lorsque vous presserez la touche F1.
.LP
Pour obtenir une version texte seul d'une page de manuel, sans retour arrire
ni caractre de soulignement, essayez

  # man foo | col -b > foo.mantxt

.SH AUTEUR
John W. Eaton est l'auteur historique de
.BR man .
Federico Lucifredi <flucifredi@acm.org> en assure aujourd'hui la maintenance.
.SH "VOIR AUSSI"
.BR apropos (1),
.BR whatis (1),
.BR less (1),
.BR groff (1),
.BR man.conf (5).
.SH TRADUCTION
.PP
Ce document est une traduction ralise par Ren Cougnenc en mai 1995 et mise
 jour par Alain Portal <aportal@univ-montp2.fr> le 7 novembre 2005.
.PP
L'quipe de traduction a fait le maximum pour raliser une adaptation
franaise de qualit. La version anglaise la plus  jour de ce document est
toujours consultable via la commande\ : \ \fBLANG=en\ man\ 1\ man\fR\ .
N'hsitez pas  signaler  l'auteur ou au traducteur, selon le cas, toute
erreur dans cette page de manuel.

