#include "common.h"

///////////////////////////////////////////////////////////////////////////////
// `
///////////////////////////////////////////////////////////////////////////////
static void cmdline_view_euc_sjis_multi_line()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    /// vvg` ///
    mclear();

    bool flg_xterm = (gXterm && !(gXtermNext || gXterm2)) || (!gXterm && (gXtermNext || gXterm2));
    if(flg_xterm)
        mmvprintw(0, 0, "X ");
    else
        mmvprintw(0, 0, "$ ");
    
    /// es` ///
    string_obj* str = (string_obj*)vector_item(gCmdLine, gCLCursor);
    char* cstr = string_c_str(str);

    int line = 0;
    char* line_top = cstr;
    int n = 0;

    int cursor_y = -1;
    int cursor_x = -1;
    while(1) {
        char* line_end = line_top + n;

        /// J[\`ʈʒuۑ ///
        if(line_end == cstr+gCursor) {
            cursor_y = line;
            cursor_x = n;
        }

        /// s̏I܂ŒBĂ ///
        if(line == 0 && (n+2 > maxx) 
                || line > 0 && (n > maxx))
        {
            if(is_kanji((unsigned char)*(line_top+n-2))) {
                line_end-=2;
            }
            else {
                line_end--;
            }

            char buf[4089];
            memcpy(buf, line_top, line_end-line_top);
            buf[line_end-line_top] = 0;

            if(line == 0) {
                mprintw("%s", buf);
            }
            else {
                mmvprintw(line, 0, "%s", buf);
            }

            line_top = line_end;
            n = 0;
            line++;
        }
        
        /// šE܂ł ///
        else if(line >= maxy) {
            break;
        }
        
        /// ̏I[܂ŒBĂ ///
        else if(!*line_end) {
            mmvprintw(line, 0, "%s", line_top);

            break;
        }

        /// ȊO ///
        else {
            n++;

            if(is_kanji((unsigned char)*(line_top + n-1))) {
                n++;
            }
        }
    }

    /// J[\ړ ///
    if(cursor_y == -1 && cursor_x == -1) {
        mmove(maxy-1, maxx-2);
    }
    else if(cursor_y == 0) {
        mmove(cursor_y, cursor_x+2);
    }
    else {
        mmove(cursor_y, cursor_x);
    }
}

/*
static void cmdline_view_euc_sjis_2line()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    bool flg_xterm = (gXterm && !(gXtermNext || gXterm2)) || (!gXterm && (gXtermNext || gXterm2));
    if(flg_xterm)
        mmvprintw(maxy - 2, 0, "X ");
    else
        mmvprintw(maxy - 2, 0, "$ ");
    
    bool kanji = false;
    bool kanji_zure = false;
    string_obj* str = (string_obj*)vector_item(gCmdLine, gCLCursor);

    for(int i=0; i<string_length(str); i++) {
        char c = string_c_str(str)[i];

        if(kanji) {
            kanji = false;
        }
        else if(is_kanji(c)) {
            kanji = true;
        }

        if(i+2 < maxx-1) {
            mmvprintw(maxy -2, 2 + i, "%c", c);
        }
        else if(i+2 == maxx-1) {
            if(kanji) {
                mmvprintw(maxy -1, 2 + i - maxx+1, "%c", c);
                kanji_zure = true;
            }
            else {
                mmvprintw(maxy -2, 2 + i, "%c", c);
            }
        }
        else {
            if(kanji_zure) {
                if(2 + i -maxx+1 < maxx-1) {
                    mmvprintw(maxy -1, 2 + i - maxx+1, "%c", c);
                }
            }
            else {
                if(2 + i - maxx < maxx-1) {
                    mmvprintw(maxy -1, 2 + i - maxx, "%c", c);
                }
            }
        }
    }


    if(kanji_zure) {    
        if(gCursor+2 < maxx-1) {
            mmove(maxy -2, 2 + gCursor);
        }
        else {
            mmove(maxy-1, 2+ gCursor -maxx+1);
        }
    }
    else {
        if(gCursor+2 < maxx) {
            mmove(maxy -2, 2 + gCursor);
        }
        else {
            mmove(maxy -1, 2 + gCursor - maxx);
        }
    }
}
*/

static void print_cmdline_core(char* buf, bool* cmd)
{
    if(strcmp(buf, "") != 0) {
        if(*cmd) {
            char buf2[PATH_MAX];
            {
                char* p2 = buf2;
                char* p = buf;
                bool dquote = false;
                bool squote = false;
                while(*p) {
                    if(!dquote && *p == '\'') {
                        p++;
                        squote = !squote;
                    }
                    else if(!squote && *p == '"') {
                        p++;
                        dquote = !dquote;
                    }
                    else if(squote || dquote) {
                        *p2++ = *p++;
                    }
                    else if(*p == '\\') {
                        p++;

                        if(*p) *p2++ = *p++;
                    }
                    else {
                        *p2++ = *p++;
                    }
                }
                *p2 = 0;
            }

            bool flg = false;
            for(int i=0; i<RARRAY(gPrograms)->len; i++) {
                if(strcmp(buf2, RSTRING(rb_ary_entry(gPrograms, i))->ptr) == 0
                    || strcmp(buf2, "read") == 0
                    || strcmp(buf2, "export") == 0)
                {
                    flg = true;
                    break;
                }
            }

            char buf3[PATH_MAX];
            {
                char* p2 = buf3;
                char* p = buf2;
                while(*p) {
                    if(*p == '\'') {
                        p++;

                        *p2++ = '\\';
                        *p2++ = '\'';
                    }
                    else {
                        *p2++ = *p++;
                    }
                }
                *p2 = 0;
            }

            char tmp[PATH_MAX];
            sprintf(tmp, "path = File.expand_path('%s'); !File.directory?(path) && File.executable?(path)", buf3);
            VALUE v = rb_eval_string(tmp);
            if(v == Qtrue) {
                flg = true;
            }

            if(gColor) {
                if(flg) {
                    mattron(kCAGreen);
                }
                else {
                    mattron(kCARed);
                }
            }
            else {
                if(flg) {
                    mattron(kCABold);
                }
            }

            mprintw("%s", buf);

            mattroff();

            *cmd = false;
        }
        else {
            if(gColor) {
                if(buf[0] == '-') {
                    mattron(kCAYellow);
                }
            }

            mprintw("%s", buf);

            if(gColor) {
                if(buf[0] == '-') {
                    mattroff();
                }
            }
        }
    }
}

static void print_cmdline(char* str, bool* cmd)
{
    char* p = str;

    bool dquote = false;
    bool squote = false;
    bool expand_cmd1 = false;
    bool expand_cmd2 = false;

    char buf[PATH_MAX];
    char* p2 = buf;

    while(1) {
        if(!dquote && !expand_cmd1 && !expand_cmd2 && *p == '\'') {
            p++;

            *p2++ = '\'';

            squote = !squote;
        }
        else if(!squote && !expand_cmd1 && !expand_cmd2 && *p == '"') {
            p++;

            *p2++ = '"';

            dquote = !dquote;
        }
        else if(!dquote && !squote && !expand_cmd2 && *p == '$' && *(p+1) == '(') {
            *p2++ = *p++;
            *p2++ = *p++;

            expand_cmd1 = true;
        }
        else if(!dquote && !squote && expand_cmd1 && !expand_cmd2 && *p == ')') {
            *p2++ = *p++;

            expand_cmd1 = false;
        }
        else if(!dquote && !squote && !expand_cmd1 && *p == '`') {
            *p2++ = *p++;

            expand_cmd2 = !expand_cmd2;
        }
        else if(*p != 0 && (squote || dquote || expand_cmd1 || expand_cmd2)) {
            *p2++ = *p++;
        }
        else if(*p == '\\') {
            p++;

            *p2++ = '\\';

            if(*p) *p2++ = *p++;
        }
        else if(*p == '&') {
            p++;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(gColor) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("&");
            mattroff();
        }
        else if(*p == '|') {
            p++;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(gColor) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("|");
            mattroff();

            *cmd = true;
        }
        else if(*p == ';') {
            p++;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(gColor) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw(";");
            mattroff();

            *cmd = true;
        }
        else if(*p == '1' && *(p+1) == '>') {
            p+=2;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(gColor) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("1>");
            mattroff();
        }
        else if(*p == '1' && *(p+1) == '>' && *(p+2) == '>') {
            p+=3;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(gColor) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("1>>");
            mattroff();
        }
        else if(*p == '2' && *(p+1) == '>') {
            p+=2;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(gColor) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("2>");
            mattroff();
        }
        else if(*p == '2' && *(p+1) == '>' && *(p+2) == '>') {
            p+=3;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(gColor) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("2>");
            mattroff();
        }
        else if(*p == '>' && *(p+1) == '>') {
            p+=2;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(gColor) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw(">>");
            mattroff();
        }
        else if(*p =='>' ) {
            p++;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(gColor) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw(">");
            mattroff();
        }
        else if(*p =='<') {
            p++;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(gColor) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("<");
            mattroff();
        }
        else if(*p == ' ' || *p == '\t') {
            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);

            while(*p == ' ' || *p == '\t') {
                mprintw("%c", *p);
                p++;
            }
        }
        else if(*p == 0) {
            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);

            break;
        }
        else if(*p == '%') {
            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);

            p++;

            switch(*p) {
                case '%':
                    p++;

                    if(gColor) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }

                    mprintw("%s", "%%");

                    mattroff();
                    break;

                case 'r':
                    p++;

                    if(gColor) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%r");
                    mattroff();
                    break;

                case 'R':
                    p++;

                    if(gColor) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%R");
                    mattroff();
                    break;

                case 'q':
                    p++;

                    if(gColor) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%q");
                    mattroff();
                    break;

                case 'Q':
                    p++;

                    if(gColor) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%Q");
                    mattroff();
                    break;

                case 's':
                    p++;

                    if(gColor) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%s");
                    mattroff();
                    break;

                case 'S':
                    p++;

                    if(gColor) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%S");
                    mattroff();
                    break;

                case 't':
                    p++;

                    if(gColor) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%t");
                    mattroff();
                    break;

                case 'o':
                    p++;

                    if(gColor) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%o");
                    mattroff();
                    break;

                case 'M':
                    p++;

                    if(gColor) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }

                    if(*p == '2') {
                        p++;

                        mprintw("%s", "%M2");
                    }
                    else {
                        mprintw("%s", "%M");
                    }

                    mattroff();
                    break;

                case 'f':
                    p++;

                    if(gColor) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%f");
                    mattroff();
                    break;

                case 'F':
                    p++;

                    if(gColor) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%F");
                    mattroff();
                    break;

                case 'x':
                    p++;

                    if(gColor) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%x");
                    mattroff();
                    break;

                case 'X':
                    p++;

                    if(gColor) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%X");
                    mattroff();
                    break;

                case 'd':
                    p++;

                    if(*p == '2') {
                        p++;

                        if(gColor) {
                            mattron(kCAMagenta);
                        }
                        else {
                            mattron(kCABold);
                        }
                        mprintw("%s", "%d2");
                        mattroff();
                    }
                    else {
                        if(gColor) {
                            mattron(kCAMagenta);
                        }
                        else {
                            mattron(kCABold);
                        }

                        mprintw("%s", "%d");
                        mattroff();
                    }

                    break;

                case 'D':
                    p++;

                    if(*p == '2') {
                        p++;

                        if(gColor) {
                            mattron(kCAMagenta);
                        }
                        else {
                            mattron(kCABold);
                        }
                        mprintw("%s", "%D2");
                        mattroff();
                    }
                    else {
                        if(gColor) {
                            mattron(kCAMagenta);
                        }
                        else {
                            mattron(kCABold);
                        }
                        mprintw("%s", "%D");
                        mattroff();
                    }
                    break;

                case 'm':
                    p++;

                    if(*p == '2') {
                        p++;

                        if(gColor) {
                            mattron(kCAMagenta);
                        }
                        else {
                            mattron(kCABold);
                        }
                        mprintw("%s", "%m2");
                        mattroff();
                    }
                    else {
                        if(gColor) {
                            mattron(kCAMagenta);
                        }
                        else {
                            mattron(kCABold);
                        }
                        mprintw("%s", "%m");
                        mattroff();
                    }

                    break;
                default:
                    mattroff();
                    mprintw("%s", "%");
                    break;
            }
        }
        else {
            *p2++ = *p++;
        }
    }
}



static void cmdline_view_euc_sjis_2line()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    bool flg_xterm = (gXterm && !(gXtermNext || gXterm2)) || (!gXterm && (gXtermNext || gXterm2));
    if(flg_xterm)
        mmvprintw(maxy - 2, 0, "X ");
    else
        mmvprintw(maxy - 2, 0, "$ ");
    
    
    string_obj* str = (string_obj*)vector_item(gCmdLine, gCLCursor);
    char* cstr = string_c_str(str);

    bool kanji_zure = false;
    bool kanji = false;
    for(int i=0; i<strlen(cstr); i++) {
        char c = cstr[i];

        if(kanji) {
            kanji = false;
        }
        else if(is_kanji(c)) {
            kanji = true;
        }

        if(i+2 == maxx-1) {
            if(kanji) {
                kanji_zure = true;
                break;
            }
        }
    }

    bool ruby_cmdline;
    if(strstr(cstr, "%r") || strstr(cstr, "%R")) {
        ruby_cmdline = true;
    }
    else {
        ruby_cmdline = false;
    }

    if(kanji_zure) {
        char line1[2048];
        char line2[2048];

        memcpy(line1, cstr, maxx-3);
        line1[maxx-3] = 0;
        strcpy(line2, cstr + maxx-3);

        if(ruby_cmdline) {
            mprintw("%s", line1);
            mmvprintw(maxy -1, 0, "%s", line2);
        }
        else {
            bool cmd = true;
            print_cmdline(line1, &cmd);
            mmove(maxy -1, 0);
            print_cmdline(line2, &cmd);
        }
    }
    else {
        if(ruby_cmdline) {
            mprintw("%s", cstr);
        }
        else {
            bool cmd = true;
            print_cmdline(cstr, &cmd);
        }
    }

    if(kanji_zure) {    
        if(gCursor+2 < maxx-1) {
            mmove(maxy -2, 2 + gCursor);
        }
        else {
            mmove(maxy-1, 2+ gCursor -maxx+1);
        }
    }
    else {
        if(gCursor+2 < maxx) {
            mmove(maxy -2, 2 + gCursor);
        }
        else {
            mmove(maxy -1, 2 + gCursor - maxx);
        }
    }
}


static void cmdline_view_utf8_multi_line()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    /// vvg` ///
    mclear();

    bool flg_xterm = (gXterm && !(gXtermNext || gXterm2)) || (!gXterm && (gXtermNext || gXterm2));
    if(flg_xterm)
        mmvprintw(0, 0, "X ");
    else
        mmvprintw(0, 0, "$ ");
    
    /// es` ///
    string_obj* str = (string_obj*)vector_item(gCmdLine, gCLCursor);
    char* cstr = string_c_str(str);

    int line = 0;
    char* line_top = cstr;
    int n = 0;
    int n2 = 0;

    int cursor_y = -1;
    int cursor_x = -1;
    while(1) {
        char* line_end = str_utfpos2pointer(line_top, n);

        char buf[4089];
        memcpy(buf, line_top, line_end-line_top);
        buf[line_end-line_top] = 0;

        /// J[\`ʈʒuۑ ///
        if(line_end == cstr+gCursor) {
            cursor_y = line;
            cursor_x = str_termlen(buf);
        }
        
        /// šE܂ł ///
        else if(line >= maxy) {
            break;
        }

        /// s̏I܂ŒBĂ ///
        if(line == 0 && (str_termlen(buf)+2 > maxx)
                || line > 0 && (str_termlen(buf) > maxx))
        {
            line_end = str_utfpos2pointer(line_top, n-1);

            memcpy(buf, line_top, line_end-line_top);
            buf[line_end-line_top] = 0;

            if(line == 0) {
                mprintw("%s", buf);
            }
            else {
                mmvprintw(line, 0, "%s", buf);
            }

            line_top = line_end;
            n = 0;
            line++;
        }

        /// ̏I[܂ŒBĂ ///
        else if(!*line_end) {
            mmvprintw(line, 0, "%s", line_top);

            break;
        }

        /// ȊO ///
        else {
            n++;
        }
    }

    /// J[\ړ ///
    if(cursor_y == -1 && cursor_x == -1) {
        mmove(maxy-1, maxx-2);
    }
    else if(cursor_y == 0) {
        mmove(cursor_y, cursor_x+2);
    }
    else {
        mmove(cursor_y, cursor_x);
    }
}

static void cmdline_view_utf8_2line()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    bool flg_xterm = (gXterm && !(gXtermNext || gXterm2)) || (!gXterm && (gXtermNext || gXterm2));
    if(flg_xterm)
        mmvprintw(maxy - 2, 0, "X ");
    else
        mmvprintw(maxy - 2, 0, "$ ");
    
    string_obj* str = (string_obj*)vector_item(gCmdLine, gCLCursor);
    char* cstr = string_c_str(str);

    bool kanji_zure = false;
    for(int i=0; i<str_utflen(cstr); i++) {
        int termpos = str_termlen2(cstr, i);

        if(termpos+2 == maxx-1) {
            char* pointer = str_utfpos2pointer(cstr, i);
            if(is_kanji(*pointer)) {
                kanji_zure = true;
                break;
            }
        }
    }

    bool ruby_cmdline;
    if(strstr(cstr, "%r") || strstr(cstr, "%R")) {
        ruby_cmdline = true;
    }
    else {
        ruby_cmdline = false;
    }

    if(kanji_zure) {
        for(int i=0; i<str_utflen(cstr); i++) {
            int termpos = str_termlen2(cstr, i);

            if(termpos+2 == maxx-1) {
                char* pointer = str_utfpos2pointer(cstr, i);

                if(is_kanji(*pointer)) {
                    char line1[2048];

                    memcpy(line1, cstr, pointer-cstr);
                    line1[pointer-cstr] = 0;

                    if(ruby_cmdline) {
                        mprintw("%s", line1);
                        mmvprintw(maxy -1, 0, "%s", pointer);
                    }
                    else {
                        bool cmd = true;
                        print_cmdline(line1, &cmd);
                        mmove(maxy -1, 0);
                        print_cmdline(pointer, &cmd);
                    }

                    break;
                }
            }
        }
    }
    else {
        if(ruby_cmdline) {
            mprintw("%s", cstr);
        }
        else {
            bool cmd = true;
            print_cmdline(cstr, &cmd);
        }
    }

    int utfpos = str_pointer2utfpos(cstr, cstr + gCursor);
    int termpos = str_termlen2(cstr, utfpos);

    if(kanji_zure) {
        if(termpos+2 < maxx-1)
            mmove(maxy -2, 2 + termpos);
        else
            mmove(maxy -1, 2 + termpos - maxx+1);
    }
    else {
        if(termpos+2 < maxx) {
            mmove(maxy -2, 2 + termpos);
        }
        else {
            mmove(maxy -1, 2 + termpos - maxx);
        }
    }
}

static void cmdline_view_utf8()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    string_obj* str = (string_obj*)vector_item(gCmdLine, gCLCursor);
    char* cstr = string_c_str(str);

    /// ̂ꂪ邩ǂH ///
    bool kanji_zure = false;
    for(int i=0; i<str_utflen(cstr); i++) {
        int termpos = str_termlen2(cstr, i);

        if(termpos+2 == maxx-1) {
            char* pointer = str_utfpos2pointer(cstr, i);
            if(is_kanji(*pointer)) {
                kanji_zure = true;
                break;
            }
        }
    }

    /// [łQsȏ̏ꍇ ///
    const int len = str_termlen(cstr);
    if(kanji_zure && (len+3 >= maxx*2)
            || !kanji_zure && (len+2 >= maxx*2)) 
    {
        cmdline_view_utf8_multi_line();
    }
    /// [łQsȉ̏ꍇ ///
    else {
        cmdline_view_utf8_2line();
    }
}

static void cmdline_view_euc_sjis()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    string_obj* str = (string_obj*)vector_item(gCmdLine, gCLCursor);
    char* cstr = string_c_str(str);

    /// ̂ꂪ邩ǂH ///
    bool kanji_zure = false;
    for(int i=0; i<strlen(cstr); i++) {
        if(i==maxx-3 && is_kanji((unsigned char)cstr[i])) {
            kanji_zure = true;
            break;
        }
    }

    /// [łQsȏ̏ꍇ ///
    const int len = strlen(cstr);
    if(kanji_zure && (len+3 >= maxx*2)
            || !kanji_zure && (len+2 >= maxx*2)) 
    {
        cmdline_view_euc_sjis_multi_line();
    }
    /// [łQsȉ̏ꍇ ///
    else {
        cmdline_view_euc_sjis_2line();
    }
}

void cmdline_view()
{
    if(gKanjiCode == kUtf8) {
        cmdline_view_utf8();
    }
    else {
        cmdline_view_euc_sjis();
    }
}

