

###############################################################################
# ディレクトリヒストリ by Lei
###############################################################################

# ヒストリ数
$my_dir_history_max = 999

$my_dir_history = Array.new()

# ディレクトリ移動メソッドオーバーライド
def dir_move(num, dir )
    super(num, dir)

    # dir_move がフルパスでも返してくれれば良かったが無いのでアクティブウィンドウを残す
    $my_dir_history.insert( 0, adir_path )

    # 最大履歴を越えていたら末尾を削除
    if $my_dir_history.size > $my_dir_history_max
        $my_dir_history.pop
    end
end

# 履歴メニュー表示
def menu_dir_history()
    menu_array = Array.new
    counter = 0
    width_max = Integer( mgetmaxx * 4/5 ) # 画面の2/3くらいは表示を許しましょうか
    
    # 引数生成
    $my_dir_history.each do |i|
        menu_array.push "(#{counter+1}) #{my_get_deform_path(i,width_max)}"
        menu_array.push KEY_a
        menu_array.push "dir_move(adir(), '#{i}')"
        counter += 1 
    end

    # defmenu 宣言 
    if menu_array.size == 0
        defmenu( 'dir_history_menu', "(1) ~ (not history)", KEY_1, "dir_move(adir(), '~')");
    else
        #message( menu_array.join "," )
        defmenu( 'dir_history_menu', *menu_array )
    end
    # menu 呼び出し
    menu('dir_history_menu')
end

# 指定のpath文字列が指定の長さ以上あれば先頭を.../にして指定文字列以下になるようにして返す
# ただし、最下層ディレクトリの名称がmax_length以上であった場合はmax_length以上の文字列が返される
# （※ディレクトリ名の中に/が入っていたら誤動作するけど入れられましたっけ？）
def my_get_deform_path( path, max_length )
    # 長くなければそのまま返す
    if path.length < max_length
        return path
    end

    # /で区切ってひっくり返して後ろから処理していきます
    dirs = path.split(/\//).reverse()
    path_str = '/' + dirs.shift # 長いディレクトリ名対策に最低1個は表示しよう
    dirs.each do |dir|
    # 長さオーバーチェック。+4は頭に'.../'がつくため
        if path_str.length + dir.length + 4 > max_length
            break
        end
        path_str = '/' + dir + path_str
    end

    path_str = '...' + path_str

    return path_str
end
