
def mark_cursor_file_and_down_cursor()
    mark(adir(), cursor(adir()), !is_marked(adir(), cursor(adir())))
    cursor_move(adir(), cursor(adir()) + 1)
end


def glob_mark(glob, user, group, permission)
    if user == "*"
        usr = -1
    else
        begin
            usr = Etc.getpwnam(user)
        rescue
            message("invalid user name")
            return
        end
    end

    if group == "*"
        grp = -1
    else
        begin
            grp = Etc.getgrnam(group)
        rescue
            message("invalid group name")
            return 
        end
    end

    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = 0
    while i < cursor_max(adir())
        fname = file_name(adir(), i)
        
        if File.fnmatch?(glob, fname) && !File.directory?(adir_path() + fname)
            if usr == -1 || File.stat(adir_path() + fname).uid == usr.uid
                if grp == -1 || File.stat(adir_path() + fname).gid == grp.gid
                    if permission == "*" || permission == get_permission(File.stat(adir_path() + fname).mode)
                        if toggle
                            mark(adir(), i, !is_marked(adir(), i))
                        else
                            mark(adir(), i, true)
                        end
                    end
                end
            end
        end

        i = i + 1
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

def glob_mark_dir(glob, user, group, permission)
    if user == "*"
        usr = -1
    else
        begin
            usr = Etc.getpwnam(user)
        rescue
            message("invalid user name")
            return
        end
    end

    if group == "*"
        grp = -1
    else
        begin
            grp = Etc.getgrnam(group)
        rescue
            message("invalid group name")
            return 
        end
    end

    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = 0
    while i < cursor_max(adir())
        fname = file_name(adir(), i)
        
        if File.fnmatch?(glob, fname) && File.directory?(adir_path() + fname) && fname != ".." && fname != "."
            if usr == -1 || File.stat(adir_path() + fname).uid == usr.uid
                if grp == -1 || File.stat(adir_path() + fname).gid == grp.gid
                    if permission == "*" || permission == get_permission(File.stat(adir_path() + fname).mode)
                        if toggle
                            mark(adir(), i, !is_marked(adir(), i))
                        else
                            mark(adir(), i, true)
                        end
                    end
                end
            end
        end

        i = i + 1
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

def glob_mark_executable(glob, user, group, permission)
    if user == "*"
        usr = -1
    else
        begin
            usr = Etc.getpwnam(user)
        rescue
            message("invalid user name")
            return
        end
    end

    if group == "*"
        grp = -1
    else
        begin
            grp = Etc.getgrnam(group)
        rescue
            message("invalid group name")
            return 
        end
    end

    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = 0
    while i < cursor_max(adir())
        fname = file_name(adir(), i)
        
        if File.fnmatch?(glob, fname) && File.executable?(adir_path() + fname) && !File.directory?(adir_path() + fname)
            if usr == -1 || File.stat(adir_path() + fname).uid == usr.uid
                if grp == -1 || File.stat(adir_path() + fname).gid == grp.gid
                    if permission == "*" || permission == get_permission(File.stat(adir_path() + fname).mode)
                        if toggle
                            mark(adir(), i, !is_marked(adir(), i))
                        else
                            mark(adir(), i, true)
                        end
                    end
                end
            end
        end

        i = i + 1
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

def glob_mark_readable(glob, user, group, permission)
    if user == "*"
        usr = -1
    else
        begin
            usr = Etc.getpwnam(user)
        rescue
            message("invalid user name")
            return
        end
    end

    if group == "*"
        grp = -1
    else
        begin
            grp = Etc.getgrnam(group)
        rescue
            message("invalid group name")
            return 
        end
    end

    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = 0
    while i < cursor_max(adir())
        fname = file_name(adir(), i)
        
        if File.fnmatch?(glob, fname) && File.readable?(adir_path() + fname) && !File.directory?(adir_path() + fname)
            if usr == -1 || File.stat(adir_path() + fname).uid == usr.uid
                if grp == -1 || File.stat(adir_path() + fname).gid == grp.gid
                    if permission == "*" || permission == get_permission(File.stat(adir_path() + fname).mode)
                        if toggle
                            mark(adir(), i, !is_marked(adir(), i))
                        else
                            mark(adir(), i, true)
                        end
                    end
                end
            end
        end

        i = i + 1
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

def glob_mark_writable(glob, user, group, permission)
    if user == "*"
        usr = -1
    else
        begin
            usr = Etc.getpwnam(user)
        rescue
            message("invalid user name")
            return
        end
    end

    if group == "*"
        grp = -1
    else
        begin
            grp = Etc.getgrnam(group)
        rescue
            message("invalid group name")
            return 
        end
    end

    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = 0
    while i < cursor_max(adir())
        fname = file_name(adir(), i)
        
        if File.fnmatch?(glob, fname) && File.writable?(adir_path() + fname) && !File.directory?(adir_path() + fname)
            if usr == -1 || File.stat(adir_path() + fname).uid == usr.uid
                if grp == -1 || File.stat(adir_path() + fname).gid == grp.gid
                    if permission == "*" || permission == get_permission(File.stat(adir_path() + fname).mode)
                        if toggle
                            mark(adir(), i, !is_marked(adir(), i))
                        else
                            mark(adir(), i, true)
                        end
                    end
                end
            end
        end

        i = i + 1
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

def glob_mark_symlink(glob, user, group, permission)
    if user == "*"
        usr = -1
    else
        begin
            usr = Etc.getpwnam(user)
        rescue
            message("invalid user name")
            return
        end
    end

    if group == "*"
        grp = -1
    else
        begin
            grp = Etc.getgrnam(group)
        rescue
            message("invalid group name")
            return 
        end
    end

    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = 0
    while i < cursor_max(adir())
        fname = file_name(adir(), i)
        
        if File.fnmatch?(glob, fname) && File.symlink?(adir_path() + fname)
            if usr == -1 || File.stat(adir_path() + fname).uid == usr.uid
                if grp == -1 || File.stat(adir_path() + fname).gid == grp.gid
                    if permission == "*" || permission == get_permission(File.stat(adir_path() + fname).mode)
                        if toggle
                            mark(adir(), i, !is_marked(adir(), i))
                        else
                            mark(adir(), i, true)
                        end
                    end
                end
            end
        end

        i = i + 1
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

def glob_mark_all(glob, user, group, permission)
    if user == "*"
        usr = -1
    else
        begin
            usr = Etc.getpwnam(user)
        rescue
            message("invalid user name")
            return
        end
    end

    if group == "*"
        grp = -1
    else
        begin
            grp = Etc.getgrnam(group)
        rescue
            message("invalid group name")
            return 
        end
    end

    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = 0
    while i < cursor_max(adir())
        fname = file_name(adir(), i)
        
        if File.fnmatch?(glob, fname) && fname != ".." && fname != "."
            if usr == -1 || File.stat(adir_path() + fname).uid == usr.uid
                if grp == -1 || File.stat(adir_path() + fname).gid == grp.gid
                    if permission == "*" || permission == get_permission(File.stat(adir_path() + fname).mode)
                        if toggle
                            mark(adir(), i, !is_marked(adir(), i))
                        else
                            mark(adir(), i, true)
                        end
                    end
                end
            end
        end

        i = i + 1
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

def regex_mark(regex, user, group, permission)
    if user == "*"
        usr = -1
    else
        begin
            usr = Etc.getpwnam(user)
        rescue
            message("invalid user name")
            return
        end
    end

    if group == "*"
        grp = -1
    else
        begin
            grp = Etc.getgrnam(group)
        rescue
            message("invalid group name")
            return 
        end
    end

    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = 0
    while i < cursor_max(adir())
        fname = file_name(adir(), i)
        
        if !File.directory?(adir_path() + fname)
            if fname =~ regex
                if usr == -1 || File.stat(adir_path() + fname).uid == usr.uid
                    if grp == -1 || File.stat(adir_path() + fname).gid == grp.gid
                        if permission == "*" || permission == get_permission(File.stat(adir_path() + fname).mode)
                            if toggle
                                mark(adir(), i, !is_marked(adir(), i))
                            else
                                mark(adir(), i, true)
                            end
                        end
                    end
                end
            end
        end
        
        i = i + 1
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

def regex_mark_dir(regex, user, group, permission)
    if user == "*"
        usr = -1
    else
        begin
            usr = Etc.getpwnam(user)
        rescue
            message("invalid user name")
            return
        end
    end

    if group == "*"
        grp = -1
    else
        begin
            grp = Etc.getgrnam(group)
        rescue
            message("invalid group name")
            return 
        end
    end

    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = 0
    while i < cursor_max(adir())
        fname = file_name(adir(), i)
        
        if File.directory?(adir_path() + fname) && fname != ".." && fname != "."
            if fname =~ regex
                if usr == -1 || File.stat(adir_path() + fname).uid == usr.uid
                    if grp == -1 || File.stat(adir_path() + fname).gid == grp.gid
                        if permission == "*" || permission == get_permission(File.stat(adir_path() + fname).mode)
                            if toggle
                                mark(adir(), i, !is_marked(adir(), i))
                            else
                                mark(adir(), i, true)
                            end
                        end
                    end
                end
            end
        end
        
        i = i + 1
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

def regex_mark_executable(regex, user, group, permission)
    if user == "*"
        usr = -1
    else
        begin
            usr = Etc.getpwnam(user)
        rescue
            message("invalid user name")
            return
        end
    end

    if group == "*"
        grp = -1
    else
        begin
            grp = Etc.getgrnam(group)
        rescue
            message("invalid group name")
            return 
        end
    end

    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = 0
    while i < cursor_max(adir())
        fname = file_name(adir(), i)
        
        if File.executable?(adir_path() + fname) && !File.directory?(adir_path() + fname)
            if fname =~ regex
                if usr == -1 || File.stat(adir_path() + fname).uid == usr.uid
                    if grp == -1 || File.stat(adir_path() + fname).gid == grp.gid
                        if permission == "*" || permission == get_permission(File.stat(adir_path() + fname).mode)
                            if toggle
                                mark(adir(), i, !is_marked(adir(), i))
                            else
                                mark(adir(), i, true)
                            end
                        end
                    end
                end
            end
        end

        i = i + 1
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

def regex_mark_readable(regex, user, group, permission)
    if user == "*"
        usr = -1
    else
        begin
            usr = Etc.getpwnam(user)
        rescue
            message("invalid user name")
            return
        end
    end

    if group == "*"
        grp = -1
    else
        begin
            grp = Etc.getgrnam(group)
        rescue
            message("invalid group name")
            return 
        end
    end

    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = 0
    while i < cursor_max(adir())
        fname = file_name(adir(), i)
        
        if File.readable?(adir_path() + fname) && !File.directory?(adir_path() + fname)
            if fname =~ regex
                if usr == -1 || File.stat(adir_path() + fname).uid == usr.uid
                    if grp == -1 || File.stat(adir_path() + fname).gid == grp.gid
                        if permission == "*" || permission == get_permission(File.stat(adir_path() + fname).mode)
                            if toggle
                                mark(adir(), i, !is_marked(adir(), i))
                            else
                                mark(adir(), i, true)
                            end
                        end
                    end
                end
            end
        end

        i = i + 1
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

def regex_mark_writable(regex, user, group, permission)
    if user == "*"
        usr = -1
    else
        begin
            usr = Etc.getpwnam(user)
        rescue
            message("invalid user name")
            return
        end
    end

    if group == "*"
        grp = -1
    else
        begin
            grp = Etc.getgrnam(group)
        rescue
            message("invalid group name")
            return 
        end
    end

    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = 0
    while i < cursor_max(adir())
        fname = file_name(adir(), i)
        
        if File.writable?(adir_path() + fname) && !File.directory?(adir_path() + fname)
            if fname =~ regex
                if usr == -1 || File.stat(adir_path() + fname).uid == usr.uid
                    if grp == -1 || File.stat(adir_path() + fname).gid == grp.gid
                        if permission == "*" || permission == get_permission(File.stat(adir_path() + fname).mode)
                            if toggle
                                mark(adir(), i, !is_marked(adir(), i))
                            else
                                mark(adir(), i, true)
                            end
                        end
                    end
                end
            end
        end

        i = i + 1
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

def regex_mark_symlink(regex, user, group, permission)
    if user == "*"
        usr = -1
    else
        begin
            usr = Etc.getpwnam(user)
        rescue
            message("invalid user name")
            return
        end
    end

    if group == "*"
        grp = -1
    else
        begin
            grp = Etc.getgrnam(group)
        rescue
            message("invalid group name")
            return 
        end
    end

    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = 0
    while i < cursor_max(adir())
        fname = file_name(adir(), i)
        
        if File.symlink?(adir_path() + fname)
            if fname =~ regex
                if usr == -1 || File.stat(adir_path() + fname).uid == usr.uid
                    if grp == -1 || File.stat(adir_path() + fname).gid == grp.gid
                        if permission == "*" || permission == get_permission(File.stat(adir_path() + fname).mode)
                            if toggle
                                mark(adir(), i, !is_marked(adir(), i))
                            else
                                mark(adir(), i, true)
                            end
                        end
                    end
                end
            end
        end

        i = i + 1
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

def regex_mark_all(regex, user, group, permission)
    if user == "*"
        usr = -1
    else
        begin
            usr = Etc.getpwnam(user)
        rescue
            message("invalid user name")
            return
        end
    end

    if group == "*"
        grp = -1
    else
        begin
            grp = Etc.getgrnam(group)
        rescue
            message("invalid group name")
            return 
        end
    end

    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = 0
    while i < cursor_max(adir())
        fname = file_name(adir(), i)
        
        if fname != ".." && fname != "."
            if fname =~ regex
                if usr == -1 || File.stat(adir_path() + fname).uid == usr.uid
                    if grp == -1 || File.stat(adir_path() + fname).gid == grp.gid
                        if permission == "*" || permission == get_permission(File.stat(adir_path() + fname).mode)
                            if toggle
                                mark(adir(), i, !is_marked(adir(), i))
                            else
                                mark(adir(), i, true)
                            end
                        end
                    end
                end
            end
        end
        
        i = i + 1
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

def mark_range_begin()
    $mark_range_begin = cursor(adir())
end

def mark_range_end()
    ret = select_string("toggle mark?", ["no", "yes"], -1)
    if ret == -1
        return
    end
    toggle = ret == 1 ? true : false

    i = $mark_range_begin
    while i <= cursor(adir()) && i < cursor_max(adir())
        if toggle
            mark(adir(), i, !is_marked(adir(), i))
        else
            mark(adir(), i, true)
        end
        i = i + 1
    end
end

def mark_with_comparison()
    if !is_one_dir()
        ret = select_string("Size", ["same", "ignore"], -1)
        
        if ret == -1
            return
        end
        
        size = ret == 0
        
        ret = select_string("Timestamp", ["same", "ignore"], -1)
        
        if ret == -1
            return
        end
        
        timestamp = ret == 0
        
        ret = select_string("Directory", ["ignore", "mark"], -1)
        
        if ret == -1
            return 
        end
        
        directory = ret == 1
        
        i = 0
        while i < cursor_max(adir())
            fname = file_name(adir(), i)
            if file_num(sdir(), fname) != -1 && fname != "." && fname != ".."
                stat1 = File.stat(adir_path()+fname)
                stat2 = File.stat(sdir_path()+fname)
                
                if (stat1.ftype() == stat2.ftype()) && (!size || size && stat1.size==stat2.size) && (!timestamp || timestamp && stat1.mtime == stat2.mtime) && (directory || !directory && stat1.ftype!="directory")
                    mark(adir(), i, true)
                end
            end
            
            i+=1
        end
    end

    if $option_sort_mark_file_up
        sort(adir())
    end
end

defmenu("mark",
    "glob mark (f)ile",                      KEY_f, "cmdline_c(\"%r%Q%o glob_mark '*', '*', '*', '*' # glob, user, group, permission\", 20, nil)",
    "glob mark (a)ll",                       KEY_a, "cmdline_c(\"%r%Q%o glob_mark_all '*', '*', '*', '*' # glob, user, group, permission\", 24, nil)",
    "glob mark (d)irectory",                 KEY_d, "cmdline_c(\"%r%Q%o glob_mark_dir '*', '*', '*', '*' # glob, user, group, permission\", 24, nil)",
    "glob mark (e)xecutable",                KEY_e, "cmdline_c(\"%r%Q%o glob_mark_executable '*', '*', '*', '*' # glob, user, group, permission\", 31, nil)",
    "glob mark (r)eadable",                  KEY_r, "cmdline_c(\"%r%Q%o glob_mark_readable '*', '*', '*', '*' # glob, user, group, permission\", 29, nil)",
    "glob mark (w)ritable",                  KEY_w, "cmdline_c(\"%r%Q%o glob_mark_writable '*', '*', '*', '*' # glob, user, group, permission\",29, nil)",
    "glob mark (s)ymlink",                   KEY_s, "cmdline_c(\"%r%Q%o glob_mark_symlink '*', '*', '*', '*' # glob, user, group, permission\", 28, nil)",
    "regex mark (F)ile",                     KEY_F, "cmdline_c(\"%r%Q%o regex_mark //, '*', '*', '*' # regex, user, group, permission\", 20, nil)",
    "regex mark (A)ll",                      KEY_A, "cmdline_c(\"%r%Q%o regex_mark_all //, '*', '*', '*' # regex, user, group, permission\", 24, nil)",
    "regex mark (D)irectory",                KEY_D, "cmdline_c(\"%r%Q%o regex_mark_dir //, '*', '*', '*' # regex, user, group, permission\", 24, nil)",
    "regex mark (E)xecutable",               KEY_E, "cmdline_c(\"%r%Q%o regex_mark_executable //, '*', '*', '*' # regex, user, group, permission\", 31, nil)",
    "regex mark (R)eadable",                 KEY_R, "cmdline_c(\"%r%Q%o regex_mark_readable //, '*', '*', '*' # regex, user, group, permission\", 29, nil)",
    "regex mark (W)ritable",                 KEY_W, "cmdline_c(\"%r%Q%o regex_mark_writable //, '*', '*', '*' # regex, user, group, permission\", 29, nil)",
    "regex mark (S)ymlink",                  KEY_S, "cmdline_c(\"%r%Q%o regex_mark_symlink //, '*', '*', '*' # regex, user, group, permission\", 28, nil)",
    "mark (c)lear",                          KEY_c, "mark_clear(adir())",
    "mark a(l)l files",                      KEY_l, "mark_all_files(adir())",
    "mark a(L)l",                            KEY_L, "mark_all(adir())",
    "mark with c(o)mparison",                KEY_o, "mark_with_comparison()"
    );




defmenu("glob_mark_menu",
    "(f)ile", KEY_f,      "cmdline_c(\"%r%Q%o glob_mark('*')\", -2, nil)",
    "(d)irectory", KEY_d, "cmdline_c(\"%r%Q%o glob_mark_dir('*')\", -2, nil)"
    );

defmenu("regex_mark_menu",
    "(f)ile", KEY_f, "cmdline_c(\"%r%Q%o regex_mark(//)\", -2, nil)",
    "(d)irectory", KEY_d, "cmdline_c(\"%r%Q%o regex_mark_dir(//)\", -2, nil)"
    );
