

###############################################################################
# grepのラッパー
###############################################################################
def mgrep(grep_cmd, editor, line_option, mark)
    if !mis_curses
        curses_init_flg = true
        minitscr()
    end

    lines = []
    cursor = 0
    scroll_top = 0

    ### grepを実行 ###
    mclear()
    mmvprintw(0,0, "grepping...")
    mrefresh()

    mendwin()
    set_signal_clear()
    if mark
        mark_files_squort = ""
        adir_mark.each() do |fname|
            mark_files_squort = mark_files_squort + " '" + fname + "'"
        end

        if !system(grep_cmd + " " + mark_files_squort + " 2>&1 | tee '#{ENV['MTEMP']}'/mfiler_out_of_grep")
            set_signal_mfiler2()
            minitscr()
            return
        end
    else
        if !system(grep_cmd)
            set_signal_mfiler2()
            minitscr()
            return
        end
    end

    set_signal_mfiler2()
    minitscr()

    f = open(ENV['MTEMP'] + "/mfiler_out_of_grep", "r")
    output = f.read()
    f.close()

    if output == ""
        mmvprintw(0,0,"no output")
        mrefresh()
        mgetch()
        return
    end

    ### grepの出力一行ごとにlinesに格納 ###
    i = 0
    tmp = ""
    while i < output.size()
        if output[i] == ?\n
            if tmp != ""
#                if lines.size < 500
                    lines.push(tmp)
#                end
            end
            tmp = ""
        else
            tmp = tmp + output[i].chr
        end

        i = i + 1
    end

    ### メインループ ###
    maxx = mgetmaxx()

    if lines.size > 0 
        key = [0, 0]
        while true
            ### view ###
            mclear()
            n = scroll_top
            while n < lines.size
                if cursor == n
                    mattron(MA_REVERSE)
                end

                line = wstrcut(lines[n], maxx-1)
                mmvprintw(n - scroll_top , 0, "%s", line)

                if cursor == n
                    mattroff()
                end
                
                n = n + 1
            end
            
            mrefresh()

            ### input ###
            key = mgetch()

            if key[1] == 14 || key[1] == KEY_DOWN
                cursor = cursor + 1
            end
            if key[1] == 16 || key[1] == KEY_UP
                cursor = cursor -1
            end
            if key[1] == 4 || key[1] == KEY_PAGEDOWN
                cursor = cursor + mgetmaxy / 2
            end
            if key[1] == 21 || key[1] == KEY_PAGEUP
                cursor = cursor - mgetmaxy / 2
            end
            if key[1] == 12
                mclear
                mrefresh
            end

            if key[1] == ?q || key[1] == 3
                lines = []
                cursor = 0
                scroll_top = 0
                break;
            end
            if key[1] == 27 || key[1] == 7
                break;
            end
            
            if key[1] == 10 || key[1] == 13
                array = lines[cursor].split(':')

                if !File.exist?(array[0])
                    output = msystem("find . -name #{array[0]}")
                    array2 = output.split
                    
                    if output.size != 0 && array2.size == 1
                        array[0] = output.chomp
                    end
                    if array2.size >  1
                        mclear()                    
                        mmvprintw(0,0, "find two or more " + array[1])
                        mrefresh()
                        mgetch()
                        
                        #array[0] = array2[0].chomp
                    end
                end

                if File.exist?(array[0]) && array[1].to_i != 0
                    # array[1] == line number
                    # array[0] == file name

                    mendwin()

                    system(editor + " " + line_option + array[1] + " " + array[0])

                    minitscr()
                end
            end

            ### modification ###
            if cursor < 0
                cursor = 0
            end
            if cursor >= lines.size
                cursor = lines.size - 1
            end
            if cursor < scroll_top
                 scroll_top = cursor
            end
            if cursor > scroll_top + mgetmaxy() - 1
                scroll_top = scroll_top + (cursor-scroll_top-mgetmaxy()) + 1
            end
        end
    end

    if curses_init_flg
        mendwin()
    end

    mark_clear(adir())

    sort(0)
    sort(1)
end
