#ifndef MFILER2_MENU
#define MFILER2_MENU

/// menu.cpp ///
struct sMenuItem {
    char* mName;
    int mKey;
    char* mCmd;

    sMenuItem(char* name, int key, char* cmd) {
        mName = STRDUP(name);
        mKey = key;
        mCmd = STRDUP(cmd);
    }
    ~sMenuItem() {
        FREE(mName);
        FREE(mCmd);
    }
};

class cMenu {
    char mTitle[256];

    int mScrollTop;
    int mCursor;

    vector_obj* mMenuItems; 
public:
    cMenu(char* title);
    ~cMenu();

    static void Init();
    static void Final();

    static void* operator new(size_t size) { return MALLOC(size); }
    static void operator delete(void* p) { FREE(p); }
    
    void Append(char* name, int key, char* cmd);
    
    /// Methods ///
    void Show();
    void Input(int meta, int key);
    void View();
};

extern bool gMenuScrollCycle;

#endif
