/*
 * fobOp[`
 */

#ifndef MINATO_DEBUG_H
#define MINATO_DEBUG_H

#include <stdlib.h>

///////////////////////////////////////////////////////////////////////////////
// `
///////////////////////////////////////////////////////////////////////////////
#define RESULT              // ԂlIɎgɂ
#define ALLOCATED           // q[vɂĊ蓖ĂlԂꍇ
#define RELEASE             // q[vɂĊ蓖Ăꂽlꍇ

#define BOOL int            // bool
#define TRUE 1              // true
#define FALSE 0             // false

///////////////////////////////////////////////////////////////////////////////
// ֐`
///////////////////////////////////////////////////////////////////////////////
ALLOCATED char* mystrdup(char* str);                    // G[`FbNstrdup
ALLOCATED void* mymalloc(size_t size);                  // G[`FbNmalloc
ALLOCATED void* myrealloc(void* ptr, size_t size);      // G[`FbNrealloc

#define P(o) { char _fname[1024]; char* _home = getenv("HOME"); strcpy(_fname, _home); strcat(_fname, "/exe.log"); FILE* f = fopen(_fname, "a"); fprintf o; fprintf(f, "\n"); fclose(f); }

///////////////////////////////////////////////////////////////////////////////
// fobO̒`
///////////////////////////////////////////////////////////////////////////////
#ifdef DEBUG

#include <stdarg.h>

/* fobOOp֐ */
void Log_Begin(BOOL clear);                         // 
void Log_End();                                     // 
void Log_Write(char* str, ...);                     // 
int Log_Writeln(char* str, ...);                    // ݁A݌s
void Log_Dump(void* buf, int size, BOOL addr);      // C[W
void Log_TraceBegin(const char* file_name, int line, const char* func_name);    // ֐Jn
void Log_TraceEnd();                                                            // ֐I

/* [N`FbNp֐ */
void CheckMemLeak_Begin();      // 
void CheckMemLeak_End();        // 
ALLOCATED void* CheckMemLeak_Malloc(size_t size, const char* file_name, int line, const char* func_name);
    // [N`FbNpAP[g
ALLOCATED char* CheckMemLeak_Strdup(char* str, const char* file_name, int line, const char* func_name);
    // [N`FbNp񊄂蓖
ALLOCATED void* CheckMemLeak_Realloc(void* ptr, size_t size, const char* file_name, int line, const char* func_name);
    // [N`FbNpAbN
void CheckMemLeak_Free(RELEASE void* memory, const char* file_name, int line, const char* func_name);
    // [N`FbNpt[

/* fobOp萔` */
#   define CHECKML_BEGIN() CheckMemLeak_Begin();
#   define LOG_BEGIN() Log_Begin(TRUE); 
#   define CHECKML_END() CheckMemLeak_End(); 
#   define LOG_END()  Log_End();

#   define M(o) Log_Writeln o;
#   define TBEGIN() Log_TraceBegin(__FILE__, __LINE__, __FUNCTION__);
#   define TEND() Log_TraceEnd();

#   define MALLOC(o) CheckMemLeak_Malloc(o, __FILE__, __LINE__, __FUNCTION__)
#   define STRDUP(o) CheckMemLeak_Strdup(o, __FILE__, __LINE__, __FUNCTION__)
#   define REALLOC(o, o2) CheckMemLeak_Realloc(o, o2, __FILE__, __LINE__, __FUNCTION__)
#   define FREE(o) CheckMemLeak_Free(o, __FILE__, __LINE__, __FUNCTION__)

///////////////////////////////////////////////////////////////////////////////
// fobOłȂƂ̒`
///////////////////////////////////////////////////////////////////////////////
#else

#   define CHECKML_BEGIN()
#   define LOG_BEGIN()
#   define CHECKML_END()  
#   define LOG_END()

#   define M(o)
#   define TBEGIN()
#   define TEND()

#   define MALLOC(o) mymalloc(o)
#   define STRDUP(o) mystrdup(o)
#   define REALLOC(o, o2) myrealloc(o, o2)
#   define FREE(o) free(o)

#endif

#endif
