extern vector_obj* gJobs;      // vector of sJob*

struct sChildProgram {
    pid_t mPid;
    vector_obj* mArgv;
    int mReturnCode;

    sChildProgram(pid_t pid, vector_obj* argv, int return_code) {
        mPid = pid;
        mArgv = vector_new(10);
        for(int i=0; i<vector_size(argv); i++) {
            string_obj* item = (string_obj*)vector_item(argv, i);
            vector_add(mArgv, string_new(string_c_str(item)));
        }

        mReturnCode = return_code;
    }
    ~sChildProgram() {
        for(int i=0; i<vector_size(mArgv); i++) {
            string_delete((string_obj*)vector_item(mArgv, i));
        }
        vector_delete(mArgv);
    }
};

struct sJob {
    int mJobId;                     // WuID
    int mNumProgs;                  // vO̐
    int mRunningProgs;              // ĂvO̐
    string_obj* mName;              // Wu̖O
    pid_t mPGroup;                  // vZXO[vID
    vector_obj* mChildPrograms;     // qvZXz

    sJob(char* name) {
        mName = string_new(name);
        int id = 0;
        while(1) {
            bool id_exist = false;
            for(int i=0; i<vector_size(gJobs); i++) {
                sJob* job = (sJob*)vector_item(gJobs, i);
                if(job->mJobId == id) {
                    id_exist = true;
                    break;
                }
            }

            if(!id_exist) {
                break;
            }

            id++;
        }
        mJobId = id;
        mNumProgs = 0;

        mChildPrograms = vector_new(10);
        
        mRunningProgs = 0;
        mPGroup = 0;
    }

    ~sJob() {
        string_delete(mName);

        for(int i=0; i<vector_size(mChildPrograms); i++) {
            delete (sChildProgram*) vector_item(mChildPrograms, i);
        }
        vector_delete(mChildPrograms);
    }

    void AddChildProgram(pid_t pid, vector_obj* argv, int return_code) {
        vector_add(mChildPrograms, new sChildProgram(pid, argv, return_code));
        mNumProgs++;
        mRunningProgs++;
    }
};

extern void shell(char* cmdline, bool hitanykey, char* title);
extern void shell_view();
extern void shell_forground_job(int num);
extern void shell_kill_all_jobs();
extern void shell_wait_backgroud_job();
extern void shell_kill_job(int num);
extern int shell_job_num();
extern char* shell_job_title(int num);
