#!/usr/bin/ruby

# This is an example file for Ming Components, version for Ruby wrapper

# First you have to copy Components.rb to your ruby catalogue 
# It should be something like:  /usr/lib/ruby/site_ruby/1.8/ming/Components.rb

# Usage: object = SWFComponents.new - initialize class 
# Then:
# object.new_movie(swfversion, hoz, ver) where
# swfversion is needed SWF file version number
# hoz and ver are the horizontal and vertical dimensions of the stage

# Then set values for 4 global ActionScript variables: a, b, c, d where
# a is a left position of the TextField (in pixels)
# b is a top position of the TextField (in pixels)
# c is the length of the TextField
# d is the height of the TextField

# make your CSS and write formatted text, you want to put into Textfield
# then set Textfield flags (border, wordWrap etc...)
# but remember: you have to preserve txtFld name!!!

# Then:
# object.scrollbar(a, b, c, d) - repeat values from above a, b, c, d
# Why repeat? Those are Ruby variables, above are ActionSript variables. It must be like that
# Multiple instances of the class SWFComponents impossible! Use Perls MultiScrollBar.pm component if you need them
# ScrollBar is resized automatically
# Author Pawel Karwowski pawel at baribal dot forall dot pl

require 'ming/Components'

go = SWFComponents.new
go.new_movie(7, 600, 400)

$movie.set_background(0xdd, 0xdd, 0xaa)

# place where purely OO language Ruby meets purely procedural language ActionScript 1.0...

$movie.add(SWFAction.new("

// set your values and repeat them in line go.scrollbar...

_global.a=10;
_global.b=30;
_global.c=300;
_global.d=100;

mycss='
.text {color: #000000; margin-left: 10px; margin-right: 5px; font-family: _sans; font-size: 11px;}
.blue {color: #000FF0; margin-left: 10px; margin-right: 5px; font-family: _sans; font-size: 11px;}
.green {color: #0FF000; margin-left: 10px; margin-right: 5px; font-family: _sans; font-size: 11px;}
.orange {color: #E89403; margin-left: 10px; margin-right: 5px; font-family: _sans; font-size: 11px;}
.red {color: #FF2222; margin-left: 20px; margin-right: 15px; font-family: _sans; font-size: 12px;}
';

// do not touch following values below: txtFld, a, b, c, d must remain... but you may change depth...

_root.createTextField('txtFld',11,a,b,c,d);
with(txtFld){ border = true; html = true; embedFonts = false; wordWrap=true;}
str = '';
str+='<span class=\"red\">1). ScrollBar component for MING.</span>&nbsp;
<span class=\"orange\">This is an Scrollbar component example for MING. The code and graphics are borrowed from SWFTools, an GNU Public Licenced, Open Source project, that also reuses some code borrowed from MING, so we are both equally legal. The original author of Scrollbar code accordingly to README file supported in SWFTools source is named Pipey.</span><br />
</span><br />&nbsp;
<span class=\"red\"> 2). Using ScrollBar.</span>&nbsp;
<p class=\"text\">Version 0.2 for Ruby is as fast as Perls versions. The speed is good for both: device and embedded fonts. Initialization of the class is made with syntax obj = SWFComponents.new, anyway multiple instances of scrollbar enabled textfields are in this version impossible.  
<span class=\"red\"> 3). TAB and ENTER.</span>&nbsp;
<p class=\"green\">You can use TAB and ENTER for navigation. It works well on slow computers, even on Pentium 133 you dont have to wait for a scrolling. This scrollbar example works with Flash 7 with mouse enabled. On Flash 6 $movies mouse does not works.
<span class=\"red\"> 4). Author.</span>&nbsp;
<p class=\"blue\">Ruby code of ScrollBar component for MING by Pawel Karwowski pawel at baribal dot forall dot pl. It is an GNU Public Licenced script.';
"))

go.scrollbar(10,30,300,100)

# add your stuff...

b = SWFBitmap.new("picture.jpg")
i = $movie.add(b)
i.move_to(10, 150)
i.scale_to(0.7)

$movie.save("scroll_ruby.swf",9)
