/*----------------------------------------------------------------------
    Character code table management function   codetable.cpp
        Written by H.Goto, Feb. 2008
        Revised by H.Goto, Feb. 2008
        Revised by H.Goto, Sep. 2008
        Revised by H.Goto, Jan. 2009
        Revised by H.Goto, May  2009
----------------------------------------------------------------------*/

/*--------------
  Copyright 2008,2009  Hideaki Goto

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
      http://www.apache.org/licenses/LICENSE-2.0
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
--------------*/


//#define		BuiltInCCtable

#include        <stdio.h>
#include        <stdlib.h>
#include        <string.h>
#include        <math.h>

#include	"siplib.h"
#include	"ocrbase.h"
#include	"codelist.h"

#ifdef	BuiltInCCtable
#include	"cctable.h"

static int load_codelist_builtin(CharCode **cclist){
	char	lbuf[CCLineLength+1];
	char	ccode[CCLineLength+1];
	char	csizestr[CCLineLength+1];
	char	charset[CCLineLength+1];
	char	posH, posV;
	char	*csizep;
	int	ncode, n;
	CharCode	*cc;
	CharCode	*cclist0;

	ncode = cctable_size;

	if ( 0 == (cclist0 = new CharCode[ ncode>0 ? ncode:1 ]) ){
		return(-2);
	}

	for ( n=0 ; n<ncode ; n++ ){
		cc = &cclist0[n];
		strcpy(lbuf, cctable[n]);
		sscanf(lbuf,"%s %s %c%c %s",ccode,csizestr,&posH,&posV,charset);
		if ( strlen(ccode) > CharCodeSize-1 ){
			delete []cclist0;
			return(n);
		}
		strcpy(cc->ccode, ccode);

		cc->sizehint = SizeHint_None;
		for ( csizep = csizestr ; *csizep ; csizep++ ){
			if ( *csizep == 'U' ){
				cc->sizehint = SizeHint_None;
			}
			else if ( *csizep == 'N' ){
				cc->sizehint |= SizeHint_Normal;
			}
			else if ( *csizep == 'S' ){
				cc->sizehint |= SizeHint_Small;
			}
			else if ( *csizep == 'T' ){
				cc->sizehint |= SizeHint_Tiny;
			}
			else{	delete []cclist0;
				return(n);
			}
		}

		cc->poshint = PosHint_None;
		if ( posH == 'L' ){
			cc->poshint = PosHint_Left;
		}
		else if ( posH == 'C' ){
			cc->poshint = PosHint_Center;
		}
		else if ( posH == 'R' ){
			cc->poshint = PosHint_Right;
		}
		else{	delete []cclist0;
			return(n);
		}
		if ( posV == 'T' ){
			cc->poshint |= PosHint_Top;
		}
		else if ( posV == 'M' ){
			cc->poshint |= PosHint_Middle;
		}
		else if ( posV == 'B' ){
			cc->poshint |= PosHint_Bottom;
		}
		else{	delete []cclist0;
			return(n);
		}

		cc->ascii = 0;
		if ( strcmp(charset,"-") == 0 ){
			cc->ascii = 1;
		}

	}

	*cclist = cclist0;
	return(n);
}

#endif



int load_codelist(char *file, CharCode **cclist){

#ifdef	BuiltInCCtable
	return( load_codelist_builtin(cclist) );
#else

	FILE	*fp;
	char	lbuf[CCLineLength+1];
	char	ccode[CCLineLength+1];
	char	csizestr[CCLineLength+1];
	char	charset[CCLineLength+1];
	char	posH, posV;
	char	*csizep;
	int	ncode, n;
	CharCode	*cc;
	CharCode	*cclist0;
	if ( NULL == (fp = fopen(file,"r")) )  return(-1);

	ncode = 0;
	while( fgets(lbuf,CCLineLength,fp) ){
		ncode++;
	}

	if ( 0 == (cclist0 = new CharCode[ ncode>0 ? ncode:1 ]) ){
		fclose(fp);
		return(-2);
	}

	fseek(fp,0,SEEK_SET);

	for ( n=0 ; fgets(lbuf,CCLineLength,fp) && n<ncode ; n++ ){
		cc = &cclist0[n];
		sscanf(lbuf,"%s %s %c%c %s",ccode,csizestr,&posH,&posV,charset);
		if ( strlen(ccode) > CharCodeSize-1 ){
			delete []cclist0;
			fclose(fp);
			return(n);
		}
		strcpy(cc->ccode, ccode);

		cc->sizehint = SizeHint_None;
		for ( csizep = csizestr ; *csizep ; csizep++ ){
			if ( *csizep == 'U' ){
				cc->sizehint = SizeHint_None;
			}
			else if ( *csizep == 'N' ){
				cc->sizehint |= SizeHint_Normal;
			}
			else if ( *csizep == 'S' ){
				cc->sizehint |= SizeHint_Small;
			}
			else if ( *csizep == 'T' ){
				cc->sizehint |= SizeHint_Tiny;
			}
			else{	delete []cclist0;
				fclose(fp);
				return(n);
			}
		}

		cc->poshint = PosHint_None;
		if ( posH == 'L' ){
			cc->poshint = PosHint_Left;
		}
		else if ( posH == 'C' ){
			cc->poshint = PosHint_Center;
		}
		else if ( posH == 'R' ){
			cc->poshint = PosHint_Right;
		}
		else{	delete []cclist0;
			fclose(fp);
			return(n);
		}
		if ( posV == 'T' ){
			cc->poshint |= PosHint_Top;
		}
		else if ( posV == 'M' ){
			cc->poshint |= PosHint_Middle;
		}
		else if ( posV == 'B' ){
			cc->poshint |= PosHint_Bottom;
		}
		else{	delete []cclist0;
			fclose(fp);
			return(n);
		}

		cc->ascii = 0;
		if ( strcmp(charset,"-") == 0 ){
			cc->ascii = 1;
		}

//		printf("%s\t%s\t\%c%c\n",ccode,csizestr,posH,posV);
	}

	fclose(fp);
	*cclist = cclist0;
	return(n);

#endif	// BuiltInCCtable

}


