/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef LUIDL_PE_TYDF2_HXX
#define LUIDL_PE_TYDF2_HXX



// USED SERVICES
    // BASE CLASSES
#include <s2_luidl/parsenv2.hxx>
#include <s2_luidl/pestate.hxx>
    // COMPONENTS
    // PARAMETERS




namespace csi
{
namespace uidl
{

class PE_Type;


class PE_Typedef : public UnoIDL_PE,
                   public ParseEnvState
{
  public:
                        PE_Typedef();
    virtual void	 	EstablishContacts(
                            UnoIDL_PE *			io_pParentPE,
                            ary::Repository &	io_rRepository,
                            TokenProcessing_Result &
                                                o_rResult );
                        ~PE_Typedef();

    virtual void	  	ProcessToken(
                            const Token &		i_rToken );

    virtual void		Process_Identifier(
                            const TokIdentifier &
                                                i_rToken );
    virtual void		Process_Punctuation(
                            const TokPunctuation &
                                                i_rToken );
    virtual void		Process_Default();

  private:
    enum E_State
    {
        e_none = 0,
        expect_description,
        expect_name,
        got_name,
        e_STATES_MAX
    };
    enum E_TokenType	/// @ATTENTION  Do not change existing values (except of tt_MAX) !!! Else array-indices will break.
    {
        tt_any = 0,
        tt_identifier,
        tt_punctuation,
        tt_MAX
    };
    typedef void (PE_Typedef::*F_TOK)(const char *);


    void				CallHandler(
                            const char *		i_sTokenText,
                            E_TokenType			i_eTokenType );

    void				On_expect_description_Any(const char * i_sText);
    void				On_expect_name_Identifier(const char * i_sText);
    void				On_got_name_Punctuation(const char * i_sText);
    void				On_Default(const char * );

    virtual void		InitData();
    virtual void		ReceiveData();
    virtual void		TransferData();
    virtual UnoIDL_PE &	MyPE();

    // DATA
    static F_TOK		aDispatcher[e_STATES_MAX][tt_MAX];

    E_State             eState;
    Dyn<PE_Type>		pPE_Type;
    ary::idl::Type_id	nType;
    String   			sName;
};



}   // namespace uidl
}   // namespace csi



#endif

