/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: externallinkfragment.cxx,v $
 *
 *  $Revision: 1.1.2.1 $
 *
 *  last change: $Author: dr $ $Date: 2007/08/23 14:16:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "oox/xls/externallinkfragment.hxx"
#include "oox/xls/externallinkbuffer.hxx"

using ::rtl::OUString;
using ::oox::core::AttributeList;
using ::oox::core::RelationPtr;

namespace oox {
namespace xls {

// ============================================================================

OoxExternalLinkFragment::OoxExternalLinkFragment(
        const GlobalDataHelper& rGlobalData, const OUString& rFragmentPath ) :
    GlobalFragmentBase( rGlobalData, rFragmentPath )
{
}

bool OoxExternalLinkFragment::onCanCreateContext( sal_Int32 nElement )
{
    switch( getCurrentContext() )
    {
        case XML_ROOT_CONTEXT: return (nElement == XLS_TOKEN( externalLink ));
        case XLS_TOKEN( externalLink ): return (nElement == XLS_TOKEN( externalBook ));
    }
    return false;
}

void OoxExternalLinkFragment::onStartElement( const AttributeList& rAttribs )
{
    switch ( getCurrentContext() )
    {
        case XLS_TOKEN( externalBook ):
            importExternalBook( rAttribs );
        break;
    }
}

void OoxExternalLinkFragment::importExternalBook( const AttributeList& rAttribs )
{
    OUString rid = rAttribs.getString( R_TOKEN( id ) );
    RelationPtr pRel = getRelations()->getRelationById(rid);
    if ( !pRel.get() )
        return;

    const OUString& rTarget = pRel->msTarget;

    // fragment path is expected to be "xl/externalLinks/externalLink[link ID].xml".
    sal_Int32 nPathLength = getFragmentPath().getLength();

    OSL_ENSURE( getFragmentPath().copy(0, 29).equalsAscii("xl/externalLinks/externalLink") && nPathLength >= 34,
                "OoxExternalLinkFragment::importExternalBook: unexpected externalLink fragment path" );

    sal_Int32 nDigits = nPathLength - 33;
    sal_Int32 nExtId = getFragmentPath().copy(29, nDigits).toInt32();
    OSL_ENSURE( nExtId > 0, "OoxExternalLinkFragment::importExternalBook: external link ID must be greater than 0" );
    getExternalLinks().setExternalLink( nExtId, rTarget );
}

// ============================================================================

} // namespace xls
} // namespace oox

