/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sharedstringsfragment.cxx,v $
 *
 *  $Revision: 1.1.2.11 $
 *
 *  last change: $Author: dr $ $Date: 2007/08/24 09:07:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "oox/xls/sharedstringsfragment.hxx"

using ::rtl::OUString;
using ::oox::core::AttributeList;

namespace oox {
namespace xls {

// ============================================================================

OoxSharedStringsFragment::OoxSharedStringsFragment(
        const GlobalDataHelper& rGlobalData, const OUString& rFragmentPath ) :
    GlobalFragmentBase( rGlobalData, rFragmentPath )
{
}

// oox.xls.ContextHelper interface --------------------------------------------

bool OoxSharedStringsFragment::onCanCreateContext( sal_Int32 nElement )
{
    switch( getCurrentContext() )
    {
        case XML_ROOT_CONTEXT:  return (nElement == XLS_TOKEN( sst ));
        case XLS_TOKEN( sst ):  return (nElement == XLS_TOKEN( si ));
        case XLS_TOKEN( si ):   return (nElement == XLS_TOKEN( t )) ||
                                       (nElement == XLS_TOKEN( r ));
        case XLS_TOKEN( r ):    return (nElement == XLS_TOKEN( rPr )) ||
                                       (nElement == XLS_TOKEN( t ));
        case XLS_TOKEN( rPr ):  return Font::isSupportedContext( nElement, getCurrentContext() );
    }
    return false;
}

void OoxSharedStringsFragment::onStartElement( const AttributeList& rAttribs )
{
    switch( getCurrentContext() )
    {
        case XLS_TOKEN( si ):
            mxString = getSharedStrings().importString( rAttribs );
        break;
        case XLS_TOKEN( t ):
            if( mxString.get() && isPreviousContext( XLS_TOKEN( si ) ) )
                mxPortion = mxString->importText( rAttribs );
        break;
        case XLS_TOKEN( r ):
            if( mxString.get() ) mxPortion = mxString->importPortion( rAttribs );
        break;
        case XLS_TOKEN( rPr ):
            if( mxPortion.get() ) mxFont = mxPortion->importFont( rAttribs );
        break;
        default:
            if( isPreviousContext( XLS_TOKEN( rPr ) ) && mxFont.get() )
                mxFont->importAttribs( getCurrentContext(), rAttribs );
    }
}

void OoxSharedStringsFragment::onEndElement( const OUString& rChars )
{
    switch( getCurrentContext() )
    {
        case XLS_TOKEN( t ):
            if( mxPortion.get() ) mxPortion->setText( rChars );
        break;
        case XLS_TOKEN( sst ):
            getSharedStrings().finalizeImport();
        break;
    }
}

// ============================================================================

} // namespace xls
} // namespace oox

