/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.util.List;
import java.util.Stack;
import org.apache.commons.jrcs.rcs.DeltaTextLine;
import org.apache.commons.jrcs.rcs.Line;
import org.apache.commons.jrcs.rcs.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeltaText {
    private Stack<DeltaTextLine> deltaStack = new Stack();
    private Node root;
    private Node prev;
    private boolean annotate;

    DeltaText(Node root, Node prev, boolean annotate) {
        this.root = root;
        this.prev = prev;
        this.annotate = annotate;
    }

    void addDeltaText(DeltaTextLine delta) {
        this.deltaStack.push(delta);
    }

    void patch(List<Line> lines) {
        if (!this.annotate) {
            while (!this.deltaStack.empty()) {
                this.deltaStack.pop().patch(this.root, this.prev, lines);
            }
        } else {
            while (!this.deltaStack.empty()) {
                this.deltaStack.pop().patchAnnotate(this.root, this.prev, lines);
            }
        }
    }
}

