/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.text.Format;
import java.text.MessageFormat;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

final class KeywordsFormat {
    final Format Header_FORMAT = new MessageFormat("$Header: {1} {2} {3, date,yyyy/MM/dd HH:mm:ss} {4} {5} $");
    final Format Id_FORMAT = new MessageFormat("$Id: {1} {2} {3, date,yyyy/MM/dd HH:mm:ss} {4} {5} $");
    final Format RCSFile_FORMAT = new MessageFormat("$RCSfile: {1} $");
    final Format Revision_FORMAT = new MessageFormat("$Revision: {2} $");
    final Format Date_FORMAT = new MessageFormat("$Date: {3, date,yyyy/MM/dd HH:mm:ss} $");
    final Format Author_FORMAT = new MessageFormat("$Author: {4} $");
    final Format State_FORMAT = new MessageFormat("$State: {5} $");
    final Format Locker_FORMAT = new MessageFormat("$Locker: {6} $");
    final Format Source_FORMAT = new MessageFormat("$Source: {0} $");
    private final Pattern ID_RE;
    private final Pattern HEADER_RE;
    private final Pattern SOURCE_RE;
    private final Pattern RCSFILE_RE;
    private final Pattern REVISION_RE;
    private final Pattern DATE_RE;
    private final Pattern AUTHOR_RE;
    private final Pattern STATE_RE;
    private final Pattern LOCKER_RE;
    private final StringSubstitution subst = new StringSubstitution();
    private final Perl5Matcher matcher = new Perl5Matcher();

    KeywordsFormat() {
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            this.ID_RE = compiler.compile("\\$Id(:[^\\$]*)?\\$");
            this.HEADER_RE = compiler.compile("\\$Header(:[^\\$]*)?\\$");
            this.SOURCE_RE = compiler.compile("\\$Source(:[^\\$]*)?\\$");
            this.RCSFILE_RE = compiler.compile("\\$RCSfile(:[^\\$]*)?\\$");
            this.REVISION_RE = compiler.compile("\\$Revision(:[^\\$]*)?\\$");
            this.DATE_RE = compiler.compile("\\$Date(:[^\\$]*)?\\$");
            this.AUTHOR_RE = compiler.compile("\\$Author(:[^\\$]*)?\\$");
            this.STATE_RE = compiler.compile("\\$State(:[^\\$]*)?\\$");
            this.LOCKER_RE = compiler.compile("\\$Locker(:[^\\$]*)?\\$");
        }
        catch (MalformedPatternException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    String update(String text, Object[] revisionInfo) {
        String data = text;
        data = this.substitute(data, this.ID_RE, this.Id_FORMAT.format(revisionInfo));
        data = this.substitute(data, this.HEADER_RE, this.Header_FORMAT.format(revisionInfo));
        data = this.substitute(data, this.SOURCE_RE, this.Source_FORMAT.format(revisionInfo));
        data = this.substitute(data, this.RCSFILE_RE, this.RCSFile_FORMAT.format(revisionInfo));
        data = this.substitute(data, this.REVISION_RE, this.Revision_FORMAT.format(revisionInfo));
        data = this.substitute(data, this.DATE_RE, this.Date_FORMAT.format(revisionInfo));
        data = this.substitute(data, this.AUTHOR_RE, this.Author_FORMAT.format(revisionInfo));
        data = this.substitute(data, this.STATE_RE, this.State_FORMAT.format(revisionInfo));
        data = this.substitute(data, this.LOCKER_RE, this.Locker_FORMAT.format(revisionInfo));
        return data;
    }

    String reset(String text) {
        String data = text;
        data = this.substitute(data, this.ID_RE, "$Id$");
        data = this.substitute(data, this.HEADER_RE, "$Header$");
        data = this.substitute(data, this.SOURCE_RE, "$Source$");
        data = this.substitute(data, this.RCSFILE_RE, "$RCSfile$");
        data = this.substitute(data, this.REVISION_RE, "$Revision$");
        data = this.substitute(data, this.DATE_RE, "$Date$");
        data = this.substitute(data, this.AUTHOR_RE, "$Author$");
        data = this.substitute(data, this.STATE_RE, "$State$");
        data = this.substitute(data, this.LOCKER_RE, "$Locker$");
        return data;
    }

    private final String substitute(String input, Pattern pattern, String substitution) {
        this.subst.setSubstitution(substitution);
        String output = Util.substitute((PatternMatcher)this.matcher, (Pattern)pattern, (Substitution)this.subst, (String)input, (int)-1);
        this.subst.setSubstitution("");
        return output;
    }
}

