/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.rcs.InvalidFileFormatException;
import org.apache.commons.jrcs.rcs.Line;
import org.apache.commons.jrcs.rcs.Lines;
import org.apache.commons.jrcs.rcs.Node;
import org.apache.commons.jrcs.rcs.NodeNotFoundException;
import org.apache.commons.jrcs.rcs.TrunkNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Path {
    private List<Node> path = new LinkedList<Node>();

    public void add(Node node) {
        this.path.add(node);
    }

    public int size() {
        return this.path.size();
    }

    public Node last() {
        if (this.size() == 0) {
            return null;
        }
        return this.path.get(this.size() - 1);
    }

    public List patch() throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.patch(false);
    }

    public List patch(boolean annotate) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.patch(new Lines(), annotate);
    }

    public List patch(List lines) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.patch(lines, false);
    }

    public List patch(List lines, boolean annotate) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        Iterator<Node> p = this.path.iterator();
        TrunkNode head = (TrunkNode)p.next();
        head.patch0(lines, annotate);
        while (p.hasNext()) {
            Node n = p.next();
            n.patch(lines, annotate);
        }
        return lines;
    }

    public List newpatch(List<Line> lines, boolean annotate) throws InvalidFileFormatException, PatchFailedException {
        if (!annotate) {
            Iterator<Node> p = this.path.iterator();
            TrunkNode head = (TrunkNode)p.next();
            head.patch0(lines, false);
            while (p.hasNext()) {
                Node n = p.next();
                n.patch(lines, false);
            }
        } else {
            ListIterator<Node> p = this.path.listIterator();
            Node n = p.next();
            Node root = n.root();
            ((TrunkNode)n).newpatch0(lines, root);
            while (p.hasNext()) {
                Node pn = p.next();
                if (pn.version.isBranch()) {
                    p.previous();
                    break;
                }
                n = pn;
                n.newpatch(lines, false, root);
            }
            if (root != n) {
                try {
                    Path ap = n.rcsnext.pathTo(root.version);
                    LinkedList<Line> annoList = new LinkedList<Line>(lines);
                    for (Node tn : ap.path) {
                        tn.newpatch(annoList, true, root);
                    }
                }
                catch (NodeNotFoundException e) {
                    // empty catch block
                }
            }
            while (p.hasNext()) {
                n = p.next();
                n.newpatch(lines, false, n);
            }
        }
        return lines;
    }
}

