/*
 * MUSCLE SmartCard Development ( http://www.linuxnet.com )
 *
 * Copyright (C) 2006-2009
 *  Ludovic Rousseau <ludovic.rousseau@free.fr>
 *
 * $Id$
 */

/**
 * @file
 * @brief This keeps a list of defines for pcsc-lite.
 */

#ifndef __pcscd_h__
#define __pcscd_h__

#define TIME_BEFORE_SUICIDE 60

#define SCARD_SCOPE_GLOBAL		0x0003	/**< Scope is global */

#define SCARD_RESET			0x0001	/**< Card was reset */
#define SCARD_INSERTED			0x0002	/**< Card was inserted */
#define SCARD_REMOVED			0x0004	/**< Card was removed */

#define PCSCLITE_CONFIG_DIR		"/etc"

#define PCSCLITE_IPC_DIR		USE_IPCDIR
#define PCSCLITE_RUN_PID		PCSCLITE_IPC_DIR "/pcscd.pid"

#define PCSCLITE_READER_CONFIG		PCSCLITE_CONFIG_DIR "/reader.conf"
#define PCSCLITE_CSOCK_NAME		PCSCLITE_IPC_DIR "/pcscd.comm"

#define PCSCLITE_SVC_IDENTITY		0x01030000	/**< Service ID */

#define PCSCLITE_VERSION_NUMBER		"1.6.1"	/**< Current version */
#define PCSCLITE_STATUS_POLL_RATE	400000		/**< Status polling rate */
#define PCSCLITE_LOCK_POLL_RATE		100000		/**< Lock polling rate */

#define PCSC_MAX_CONTEXT_THREADS 200
#define PCSC_MAX_CONTEXT_CARD_HANDLES 200
#define PCSC_MAX_READER_HANDLES 200

#define PCSCLITE_STATUS_WAIT		200000	/**< Status Change Sleep */
#define MAX_DEVICENAME		255

#define MAX_BUFFER_SIZE			264	/**< Maximum Tx/Rx Buffer for get/set attributes */
#define MAX_BUFFER_SIZE_EXTENDED	(4 + 3 + (1<<16) + 3)	/**< max APDU (64K + APDU + Lc + Le) Tx/Rx Buffer */

#endif
