/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.retroweaver.runtime.java.lang.Class_;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.Annotation;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.AnnotationFormatError;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.AnnotationImpl;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIB
implements ClassVisitor {
    private Class class_;
    private Map<String, Annotation> classAnnotations = new HashMap<String, Annotation>();
    private Map<String, Map<String, Annotation>> methodAnnotations = new HashMap<String, Map<String, Annotation>>();
    private Map<String, ArrayList<Map<String, Annotation>>> methodParameterAnnotations = new HashMap<String, ArrayList<Map<String, Annotation>>>();
    private Map<String, Map<String, Annotation>> fieldAnnotations = new HashMap<String, Map<String, Annotation>>();
    private Map<String, Annotation> inheritedClassAnnotations = new HashMap<String, Annotation>();
    private Map<String, Object> cachedMethodDefaults;
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY;
    private static final Annotation[][] EMPTY_ANNOTATION_ARRAY_ARRAY;
    private static final Method cloneMethod;
    private static final Map<Class, AIB> classDescriptors;
    public static final AIBEmptyVisitor EMPTY_VISITOR;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$java$lang$Object;
    private static final /* synthetic */ Class class$net$sourceforge$retroweaver$runtime$java$lang$annotation$AIB;

    private AIB(Class c) {
        this.class_ = c;
        this.readClassStream(c.getName(), this);
    }

    private void readClassStream(String name, ClassVisitor cv) {
        String resource = new StringBuffer().append("/").append(name.replace('.', '/')).append(".class").toString();
        InputStream classStream = this.class_.getResourceAsStream(resource);
        try {
            ClassReader r = new ClassReader(classStream);
            r.accept(cv, 7);
            Class parent = this.class_.getSuperclass();
            if (parent != null) {
                AIB parentAib = AIB.getAib(parent);
                for (Map.Entry<String, Annotation> entry : parentAib.inheritedClassAnnotations.entrySet()) {
                    this.inheritedClassAnnotations.put(entry.getKey(), entry.getValue());
                }
            }
            for (Map.Entry<String, Annotation> entry : this.classAnnotations.entrySet()) {
                this.inheritedClassAnnotations.put(entry.getKey(), entry.getValue());
            }
        }
        catch (IOException e) {
            throw new AnnotationFormatError(new StringBuffer().append("[Retroweaver] Unable to read annotation data for: ").append(name).toString(), e);
        }
        finally {
            try {
                if (classStream != null) {
                    classStream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public Annotation[] getClassAnnotations() {
        return this.inheritedClassAnnotations.values().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public Annotation[] getDeclaredClassAnnotations() {
        return this.classAnnotations.values().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public <T extends Annotation> T getClassAnnotation(Class<T> annotationType) {
        return (T)this.inheritedClassAnnotations.get(annotationType.getName());
    }

    public Annotation[] getFieldAnnotations(String fieldName) {
        Map<String, Annotation> annotations = this.fieldAnnotations.get(fieldName);
        return annotations.values().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public <T extends Annotation> T getFieldAnnotation(String fieldName, Class<T> annotationType) {
        Map<String, Annotation> annotations = this.fieldAnnotations.get(fieldName);
        return (T)annotations.get(annotationType.getName());
    }

    private String getMethodIdentifier(String methodName, Class[] parameterTypes, Class returnType) {
        StringBuffer b = new StringBuffer(methodName);
        b.append('(');
        for (Class c : parameterTypes) {
            b.append(Type.getDescriptor((Class)c));
        }
        b.append(')').append(Type.getDescriptor((Class)returnType));
        return b.toString();
    }

    public Annotation[] getMethodAnnotations(String methodName, Class[] parameterTypes, Class returnType) {
        Map<String, Annotation> annotations = this.methodAnnotations.get(this.getMethodIdentifier(methodName, parameterTypes, returnType));
        if (annotations == null) {
            return EMPTY_ANNOTATION_ARRAY;
        }
        return annotations.values().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public <T extends Annotation> T getMethodAnnotation(String methodName, Class[] parameterTypes, Class returnType, Class<T> annotationType) {
        Map<String, Annotation> annotations = this.methodAnnotations.get(this.getMethodIdentifier(methodName, parameterTypes, returnType));
        if (annotations == null) {
            return null;
        }
        return (T)annotations.get(annotationType.getName());
    }

    private Map<String, Object> getMethodDefaults() {
        if (!$assertionsDisabled && !Class_.isAnnotation(this.class_)) {
            throw new AssertionError();
        }
        if (this.cachedMethodDefaults == null) {
            DefaultValueVisitor v = new DefaultValueVisitor();
            this.cachedMethodDefaults = v.parseAttributes(this.class_.getName());
        }
        return this.cachedMethodDefaults;
    }

    public Object getDefaultValue(String methodName) {
        if (!$assertionsDisabled && !Class_.isAnnotation(this.class_)) {
            throw new AssertionError();
        }
        Object o = this.getMethodDefaults().get(methodName);
        if (o == null) {
            return null;
        }
        if (o.getClass().isArray()) {
            try {
                o = cloneMethod.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return o;
    }

    public Annotation[][] getMethodParameterAnnotations(String methodName, Class[] parameterTypes, Class returnType) {
        ArrayList<Map<String, Annotation>> annotations = this.methodParameterAnnotations.get(this.getMethodIdentifier(methodName, parameterTypes, returnType));
        if (annotations == null) {
            return EMPTY_ANNOTATION_ARRAY_ARRAY;
        }
        if (annotations.size() != parameterTypes.length) {
            throw new AnnotationFormatError("inconsistent parameter count");
        }
        Annotation[][] a = new Annotation[parameterTypes.length][];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Map<String, Annotation> map = annotations.get(i);
            a[i] = map.values().toArray(EMPTY_ANNOTATION_ARRAY);
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AIB getAib(Class c) {
        Class clazz = c;
        synchronized (clazz) {
            AIB aib = classDescriptors.get(c);
            if (aib == null) {
                aib = new AIB(c);
                classDescriptors.put(c, aib);
            }
            return aib;
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (!visible) {
            return EMPTY_VISITOR;
        }
        return new TopLevelAnnotation(desc, this.classAnnotations);
    }

    public FieldVisitor visitField(int access, final String fieldName, String desc, String signature, Object value) {
        return new FieldVisitor(){
            Map<String, Annotation> annotations = new HashMap<String, Annotation>();

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (!visible) {
                    return EMPTY_VISITOR;
                }
                return new TopLevelAnnotation(desc, this.annotations);
            }

            public void visitAttribute(Attribute attr) {
            }

            public void visitEnd() {
                AIB.this.fieldAnnotations.put(fieldName, this.annotations);
            }
        };
    }

    public MethodVisitor visitMethod(int access, final String methodName, final String desc, String signature, String[] exceptions) {
        return new MethodAdapter(EMPTY_VISITOR){
            Map<String, Annotation> ma;
            ArrayList<Map<String, Annotation>> pa;
            {
                super(x0);
                this.ma = new HashMap<String, Annotation>();
                this.pa = new ArrayList();
            }

            public AnnotationVisitor visitAnnotationDefault() {
                return EMPTY_VISITOR;
            }

            public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                if (!visible) {
                    return EMPTY_VISITOR;
                }
                return new TopLevelAnnotation(desc2, this.ma);
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc2, boolean visible) {
                HashMap<String, Annotation> map;
                if (!visible) {
                    return EMPTY_VISITOR;
                }
                if (parameter < this.pa.size()) {
                    map = this.pa.get(parameter);
                } else {
                    map = new HashMap();
                    this.pa.add(parameter, map);
                }
                return new TopLevelAnnotation(desc2, map);
            }

            public void visitEnd() {
                String name = methodName + desc;
                AIB.this.methodAnnotations.put(name, this.ma);
                AIB.this.methodParameterAnnotations.put(name, this.pa);
            }
        };
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitEnd() {
    }

    static {
        Class<?> clazz = class$net$sourceforge$retroweaver$runtime$java$lang$annotation$AIB;
        if (clazz == null) {
            clazz = class$net$sourceforge$retroweaver$runtime$java$lang$annotation$AIB = new AIB[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        EMPTY_ANNOTATION_ARRAY = new Annotation[0];
        EMPTY_ANNOTATION_ARRAY_ARRAY = new Annotation[0][];
        try {
            Class<?> clazz2 = class$java$lang$Object;
            if (clazz2 == null) {
                clazz2 = class$java$lang$Object = new Object[0].getClass().getComponentType();
            }
            cloneMethod = clazz2.getDeclaredMethod("clone", new Class[0]);
            cloneMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage());
        }
        classDescriptors = new Hashtable<Class, AIB>();
        EMPTY_VISITOR = new AIBEmptyVisitor();
    }

    public static final class AIBEmptyVisitor
    implements ClassVisitor,
    FieldVisitor,
    MethodVisitor,
    AnnotationVisitor {
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        public void visitSource(String source, String debug) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return this;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return this;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return this;
        }

        public void visitEnd() {
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return this;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return this;
        }

        public void visitCode() {
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        }

        public void visitInsn(int opcode) {
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitVarInsn(int opcode, int var) {
        }

        public void visitTypeInsn(int opcode, String desc) {
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitLdcInsn(Object cst) {
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        }

        public void visitLineNumber(int line, Label start) {
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public void visit(String name, Object value) {
        }

        public void visitEnum(String name, String desc, String value) {
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return this;
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }
    }

    /*
     * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TopLevelAnnotation
    extends AbstractAnnotationVisitor {
        private final Map<String, Annotation> annotations;
        private final Map<String, Object> attributes;

        TopLevelAnnotation(String className, Map<String, Annotation> annotations) {
            super(null, className);
            this.annotations = annotations;
            String type = Type.getType((String)className).getClassName();
            this.attributes = new HashMap<String, Object>(AIB.getAib(this.getClass(type)).getMethodDefaults());
        }

        private String getClassNameFromInternalName(String name) {
            if (name.charAt(0) != 'L') {
                return name;
            }
            return name.replace('/', '.').substring(1, name.length() - 1);
        }

        @Override
        void insertValue(String name, Object value) {
            String key = this.getClassNameFromInternalName(name);
            this.attributes.put(key, value);
        }

        public AnnotationVisitor visitArray(String name) {
            try {
                String type = Type.getType((String)this.className).getClassName();
                Method m = Class.forName(type).getMethod(name, new Class[0]);
                type = m.getReturnType().getName();
                return new ArrayAnnotation(this, name, type);
            }
            catch (Exception e) {
                throw new AnnotationFormatError(e);
            }
        }

        public void visitEnd() {
            Annotation annotation = this.createAnnotation(this.className, this.attributes);
            String key = this.getClassNameFromInternalName(this.className);
            this.annotations.put(key, annotation);
        }
    }

    /*
     * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultAnnotation
    extends AbstractAnnotationVisitor {
        private final String type;
        private final Map<String, Object> attributes;

        DefaultAnnotation(String className, String type, Map<String, Object> attributes) {
            super(null, className);
            this.type = type;
            this.attributes = attributes;
        }

        @Override
        void insertValue(String name, Object value) {
            this.attributes.put(this.className, value);
        }

        public AnnotationVisitor visitArray(String name) {
            return new ArrayAnnotation(this, this.className, this.type);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new NestedAnnotation(this, this.className);
        }

        public void visitEnd() {
        }
    }

    private class NestedAnnotation
    extends AbstractAnnotationVisitor {
        private final Map<String, Object> attributes;

        NestedAnnotation(AbstractAnnotationVisitor parent, String className) {
            super(parent, className);
            this.attributes = new HashMap<String, Object>();
        }

        void insertValue(String name, Object value) {
            this.attributes.put(name, value);
        }

        public AnnotationVisitor visitArray(String name) {
            throw new UnsupportedOperationException();
        }

        public void visitEnd() {
            Annotation annotation = this.createAnnotation(this.className, this.attributes);
            this.parent.insertValue(this.className, annotation);
        }
    }

    private class ArrayAnnotation
    extends AbstractAnnotationVisitor {
        private final String type;
        private final List<Object> values;

        ArrayAnnotation(AbstractAnnotationVisitor parent, String className, String type) {
            super(parent, className);
            this.values = new LinkedList<Object>();
            this.type = type;
        }

        void insertValue(String name, Object value) {
            this.values.add(value);
        }

        public AnnotationVisitor visitArray(String name) {
            throw new UnsupportedOperationException("Nested arrays are not allowed");
        }

        public void visitEnd() {
            Class<?> c = this.getClass(this.type.replace('/', '.'));
            c = c.getComponentType();
            Object[] a = Array.newInstance(c, this.values.size());
            if (!this.values.isEmpty()) {
                a = this.values.toArray((Object[])a);
            }
            this.parent.insertValue(this.className, a);
        }
    }

    /*
     * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractAnnotationVisitor
    implements AnnotationVisitor {
        protected final AbstractAnnotationVisitor parent;
        protected final String className;

        AbstractAnnotationVisitor(AbstractAnnotationVisitor parent, String className) {
            this.parent = parent;
            this.className = className;
        }

        protected Class getClass(String name) {
            try {
                return Class.forName(name, true, AIB.this.class_.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new AnnotationFormatError(new StringBuffer().append("[Retroweaver] Unable to find class: ").append(name).toString(), e);
            }
        }

        protected Annotation createAnnotation(String className, Map<String, Object> attributes) {
            String internalName = Type.getType((String)className).getClassName();
            Class type = this.getClass(internalName);
            Annotation a = AnnotationImpl.createAnnotation(type, attributes);
            return a;
        }

        private Object getEnumValue(String desc, String value) {
            String name = Type.getType((String)desc).getClassName();
            Class c = this.getClass(name);
            return Enum.valueOf(c, value);
        }

        abstract void insertValue(String var1, Object var2);

        public void visit(String name, Object value) {
            Object v;
            if (value instanceof Type) {
                Type t = (Type)value;
                v = this.getClass(t.getClassName());
            } else {
                v = value;
            }
            this.insertValue(name, v);
        }

        public void visitEnum(String name, String desc, String value) {
            this.insertValue(name, this.getEnumValue(desc, value));
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new NestedAnnotation(this, desc);
        }
    }

    /*
     * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultValueVisitor
    implements ClassVisitor {
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        DefaultValueVisitor() {
        }

        Map<String, Object> parseAttributes(String className) {
            AIB.this.readClassStream(className, this);
            return this.attributes;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return EMPTY_VISITOR;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return EMPTY_VISITOR;
        }

        public MethodVisitor visitMethod(int access, final String methodName, final String desc, String signature, String[] exceptions) {
            return new MethodAdapter(EMPTY_VISITOR){

                public AnnotationVisitor visitAnnotationDefault() {
                    String type = desc.substring(2);
                    return new DefaultAnnotation(methodName, type, DefaultValueVisitor.this.attributes);
                }

                public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                    return EMPTY_VISITOR;
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc2, boolean visible) {
                    return EMPTY_VISITOR;
                }
            };
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        public void visitSource(String source, String debug) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public void visitEnd() {
        }
    }
}

