/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sourceforge.retroweaver.RetroWeaver;
import net.sourceforge.retroweaver.RetroWeaverException;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetroWeaverClassLoader
extends ClassLoader {
    private RetroWeaver retroWeaver;
    private List<ClassPathElement> classPathElements;

    protected void setWeaver(RetroWeaver retroWeaver) {
        this.retroWeaver = retroWeaver;
    }

    protected void setClassPath(List<String> classPath) {
        this.classPathElements = new LinkedList<ClassPathElement>();
        for (String pathEntry : classPath) {
            File f = new File(pathEntry);
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                this.addDirectoryClassPathElement(pathEntry);
                continue;
            }
            this.addJarClassPathElement(pathEntry);
        }
    }

    protected void setClassPath(String classPath) {
        LinkedList<String> l = new LinkedList<String>();
        if (classPath != null) {
            StringTokenizer t = new StringTokenizer(classPath, File.pathSeparator);
            while (t.hasMoreTokens()) {
                l.add(t.nextToken());
            }
        }
        this.setClassPath(l);
    }

    protected void addDirectoryClassPathElement(String dirName) {
        DirectoryElement e = new DirectoryElement(dirName);
        this.classPathElements.add(e);
    }

    protected void addJarClassPathElement(String jarName) {
        try {
            JarElement e = new JarElement(jarName);
            this.classPathElements.add(e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String resourceName = new StringBuffer().append(name.replace('.', '/')).append(".class").toString();
        for (ClassPathElement e : this.classPathElements) {
            boolean weaved;
            if (!e.hasResource(resourceName)) continue;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            InputStream is = e.getResourceStream(resourceName);
            try {
                weaved = this.retroWeaver.weave(is, name, bos);
            }
            catch (IOException ioe) {
                throw new RetroWeaverException(new StringBuffer().append("Problem weaving class ").append(name).append(": ").append(ioe.getMessage()).toString());
            }
            byte[] b = weaved ? bos.toByteArray() : e.getResourceData(resourceName);
            Class<?> clazz = this.defineClass(name.replace('/', '.'), b, 0, b.length);
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    protected byte[] getClassData(String name) throws ClassNotFoundException {
        String resourceName = new StringBuffer().append(name.replace('.', '/')).append(".class").toString();
        for (ClassPathElement e : this.classPathElements) {
            if (!e.hasResource(resourceName)) continue;
            byte[] b = e.getResourceData(resourceName);
            return b;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        for (ClassPathElement e : this.classPathElements) {
            if (!e.hasResource(name)) continue;
            return e.getResourceURL(name);
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> l = new ArrayList<URL>();
        for (ClassPathElement e : this.classPathElements) {
            if (!e.hasResource(name)) continue;
            l.add(e.getResourceURL(name));
        }
        return Collections.enumeration(l);
    }

    private static class JarElement
    extends ClassPathElement {
        private final String jarName;
        private final ZipFile jarFile;
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$net$sourceforge$retroweaver$RetroWeaverClassLoader;

        JarElement(String jarName) throws IOException {
            this.jarName = jarName;
            this.jarFile = new ZipFile(jarName);
        }

        protected boolean hasResource(String name) {
            ZipEntry entry = this.jarFile.getEntry(name);
            return entry != null;
        }

        protected URL getResourceURL(String name) {
            if (!$assertionsDisabled && !this.hasResource(name)) {
                throw new AssertionError();
            }
            try {
                return new URL("jar:file:" + this.jarName + "!/" + name);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        protected InputStream getResourceStream(String name) {
            if (!$assertionsDisabled && !this.hasResource(name)) {
                throw new AssertionError();
            }
            try {
                ZipEntry entry = this.jarFile.getEntry(name);
                return this.jarFile.getInputStream(entry);
            }
            catch (IOException ioe) {
                return null;
            }
        }

        static {
            Class<?> clazz = class$net$sourceforge$retroweaver$RetroWeaverClassLoader;
            if (clazz == null) {
                clazz = class$net$sourceforge$retroweaver$RetroWeaverClassLoader = new RetroWeaverClassLoader[0].getClass().getComponentType();
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }
    }

    private static class DirectoryElement
    extends ClassPathElement {
        private final String dirName;
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$net$sourceforge$retroweaver$RetroWeaverClassLoader;

        DirectoryElement(String dirName) {
            this.dirName = dirName;
        }

        protected boolean hasResource(String name) {
            String fullPath = this.dirName + File.separatorChar + name;
            File f = new File(fullPath);
            return f.exists() && f.isFile();
        }

        protected URL getResourceURL(String name) {
            if (!$assertionsDisabled && !this.hasResource(name)) {
                throw new AssertionError();
            }
            String fullPath = this.dirName + File.separatorChar + name;
            try {
                return new URL("file:" + fullPath);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        protected InputStream getResourceStream(String name) {
            if (!$assertionsDisabled && !this.hasResource(name)) {
                throw new AssertionError();
            }
            try {
                File f = new File(this.dirName + File.separatorChar + name);
                return new FileInputStream(f);
            }
            catch (IOException ioe) {
                return null;
            }
        }

        static {
            Class<?> clazz = class$net$sourceforge$retroweaver$RetroWeaverClassLoader;
            if (clazz == null) {
                clazz = class$net$sourceforge$retroweaver$RetroWeaverClassLoader = new RetroWeaverClassLoader[0].getClass().getComponentType();
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }
    }

    private static abstract class ClassPathElement {
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$net$sourceforge$retroweaver$RetroWeaverClassLoader;

        private ClassPathElement() {
        }

        protected abstract boolean hasResource(String var1);

        protected abstract URL getResourceURL(String var1);

        protected abstract InputStream getResourceStream(String var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected byte[] getResourceData(String name) {
            if (!$assertionsDisabled && !this.hasResource(name)) {
                throw new AssertionError();
            }
            InputStream is = this.getResourceStream(name);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataInputStream ds = new DataInputStream(is);
            byte[] b = new byte[2048];
            try {
                int i;
                while ((i = ds.read(b)) != -1) {
                    bos.write(b, 0, i);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                byte[] byArray = null;
                return byArray;
            }
            finally {
                try {
                    ds.close();
                }
                catch (IOException e) {}
            }
        }

        static {
            Class<?> clazz = class$net$sourceforge$retroweaver$RetroWeaverClassLoader;
            if (clazz == null) {
                clazz = class$net$sourceforge$retroweaver$RetroWeaverClassLoader = new RetroWeaverClassLoader[0].getClass().getComponentType();
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }
    }
}

