/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include <assert.h>
#include <qlineedit.h>
#include <q3textedit.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <list>
#include <string>
using namespace std;
#include "editcomponentimpl.h"
#include "xbsch.h"
#include "xbschcomponent.h"


/* 
 *  Constructs a editcomponent which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
editcomponent::editcomponent( QWidget* parent,  const char* name, bool modal, Qt::WFlags fl )
    : editcomponentBase( parent, name, modal, fl )
{
	m_block = 1;
	m_maxblock = 1;
	m_compInfoIndex = NULL;
	m_nameVert =false;
	m_referenceVert =false;
}


/*  
 *  Destroys the object and frees any allocated resources
 */
editcomponent::~editcomponent()
{
    // no need to delete child widgets, Qt does it all for us

}

int editcomponent::exec()
{
	EditNote->setText(m_strNote);
	EditName->setText(m_strName);
	OriginalName->setText(m_orgName);
	EditReference->setText(m_strReference);
	if(m_compInfoIndex!=NULL){
		m_maxblock = m_compInfoIndex->block();
		m_block++;
		if(m_block<1) m_block=1;
		else if(m_block>m_maxblock) m_block=m_maxblock;
	}else{
		m_block  =1;
		m_maxblock =1;
	}
	SpinBlock->setMaxValue(m_maxblock);
	SpinBlock->setMinValue(1);
	SpinBlock->setValue(m_block);

	CheckReferenceVert -> setChecked(m_referenceVert);
	CheckNameVert -> setChecked(m_nameVert);
	
	EditName->setFocus();
	return editcomponentBase::exec();
}

void editcomponent::accept()
{
	m_strNote		= EditNote->text();
	m_strName		= EditName->text();
	m_strReference	= EditReference->text();
	m_block			= SpinBlock->value()-1;
	if(m_block<0) m_block = 0;
	m_nameVert		= CheckNameVert-> isChecked();
	m_referenceVert	= CheckReferenceVert-> isChecked();
	editcomponentBase::accept();
}

void editcomponent::blockChanged(int block)
{
	if(block>=1 && block<=m_maxblock){
		//qDebug("editcomponent::blockChanged(int)   %d",block);
		setPinNum(block);
	}
}

void editcomponent::setCompIndex(const SCompIndex* pIndex)
{
	m_compInfoIndex = pIndex;
}

void editcomponent::setPinNum(int block)
{
	if(m_compInfoIndex==NULL) return;
	block--;	//ɽ1Ūˤ0ʤΤǥǥ
	QString str="";
	int index=0;
	int maxpin = m_compInfoIndex->pinCount();
	if(maxpin>0){
		while(1){
			str+=QString::fromLocal8Bit(m_compInfoIndex->pin(index)->pinNum(block));
			index++;
			if(index >= maxpin || str.length()>30)break;
			str+=',';
		}
	}
	PinNumber->setText(str);
}
