/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#ifndef XBSCHDOC_H
#define XBSCHDOC_H


#include <list>
using namespace std;

#include "xbschobj.h"
#include "xbschjunc.h"
#include "xbschlabel.h"
#include "xbschcomment.h"
#include "xbschtag.h"
#include "xbschcomponent.h"

#include "xbschline.h"
#include "xbschentry.h"
#include "xbschdelobj.h"
#include "xbschsheetinfo.h"
#include "ce3io.h"

//typedef list<string> stringList;
//typedef list<string>::iterator stringListIterator;

typedef list<SXBSchObj*> XBSchObjList;
typedef list<SXBSchObj*>::iterator XBSchObjListIterator;
typedef list<SXBSchObj*>::reverse_iterator XBSchObjListRevIterator;

typedef list<SPoint> SPointList;
typedef list<SPoint>::iterator SPointListIterator;

class SXBSchSheetInfo;
class SXBSchWire;

enum FIND_TARGET_FLAFS
{
	FINDTGT_TAG			=1,
	FINDTGT_LABEL		=2,
	FINDTGT_COMMENT		=4,
	FINDTGT_NAME		=8,
	FINDTGT_NAMELIB		=16,
	FINDTGT_NUM			=32
};


class SPointEmum
{
public:
	SPointEmum();
	virtual ~SPointEmum();
	bool addSPoint(SPoint point);

	SPointList m_list;
};

class SXBSchDoc
{
public:
	SXBSchDoc();
	virtual ~SXBSchDoc();
	bool m_bDoTidyUp;


protected:


	bool m_bDirty;			//ɥȤФѹȯȤtrueˤʤ롣
	bool m_bTempDirty;		//ǡФѹȯȤtrueˤʤ롣
	bool m_bTempNewPlace;	//ǡ֤ΤڡȥǡΤȤtrue

	SSize m_sizeSheet;	//ȤΥ¸
	int m_nOpCount;				//ֹ
	int m_nOldestOpCount;		//äȤŤֹ
	SRect m_rcTempArea;			//	
	SRect m_rcRotateRect;		//žȿž濴֤뤿Υꥢ
	SPoint m_ptTempSnapPoint;	//֥Ȥ򥹥ʥåפϤåɤ˾褦ˤ
	bool m_bSelectForDrag;
	unsigned m_visibleLayer;
	int m_editLayer;




protected:
	//β bDel  true ΤȤϡԤ
	//public  resetSelect()  del() ƤФ롣
	//ɥȤѹäȤtrue֤
	bool resetSelect_1(bool bDel=false);

	void pickupJunction(const SRect& rc);//٤Ƥܹ m_listWorkJunc Ф롣
	void selectForDragJunction(int scanMax,const SRect& rc);	//ϰܹ򡣤٤Ƥܹm_listWorkJunc Ф롣
	int divideWire(SXBSchWire* swire,const SRect& rc,SXBSchWire** dwire);
	void selectForDragWire(int scanMax,const SRect& rc);		//ɥåΤΥ磻䡼
	void selectForDragExceptJuncWire(int scanMax,const SRect& rc);//ɥåΤܹ磻䡼ʳ
	void selectForDragPinConnection(int scanMax,const SRect& rc,bool bCutOffPinWire);//ɥåΤΥԥ
	bool selectForDragPin(int scanMax,const SPoint pt);//ꤷ˥ԥ󤬸Ĥä饼Ĺ磻䡼֤

	

public:  //ȥ꡼I/OϢ
	bool writeMinimumLb3(SWriteCE3& wce3,XBSchObjList* pList,bool bOwnOnly);
	bool writeCe3(SWriteCE3& wce3,XBSchObjList* pList,bool bAllObj,const SPoint* pptOrigin);
	bool readCe3(	SReadCE3& rce3,
					XBSchObjList* pList,
					const SPoint* pptOrigin,
					SXBSchSheetInfo* pSheetInfo);

public:
	XBSchObjList m_listMain;
	XBSchObjList m_listTemp;
protected:
	XBSchObjList m_listWorkJunc;	//ѤΥꥢ ɥåǻ
	XBSchObjList m_listWorkWire;	//ѤΥꥢ ɥåǻ

//----- find -----
protected:
	virtual bool findStringCompare(const char* szTarget,const char* sz,bool bMatchWhole);
public:
	bool findStart(const char* sz,bool bMatchWhole,unsigned int targetFlags);
	bool find(bool bStart=false);
	//ּθפǽ?
	bool canFindNext(){return m_bFindCommandActive;}
protected:
	bool m_bFindCommandActive;
	string	m_strFind;
	bool	m_bFindMatchWhole;
	unsigned int m_nTargetFlags;
	XBSchObjListRevIterator m_reviteFind;
//----- find -----


public:
	void setDirty(bool flag = true){m_bDirty = flag;}
	void setTempDirty(bool flag = true){m_bTempDirty = flag;}

	bool isDirty(){return (m_bDirty || m_bTempDirty || m_bTempNewPlace);}	//Ǹ¸ΤȤѹäɤ֤
	bool isEmpty();	//̥֥ȤĤǤ⤢false֤
	void SetSheetSize(const SSize& size);
	SSize SheetSize(){return m_sizeSheet;}



public:
//20060603	//Ǥɲ ֹ֤
//20060603	int add(SXBSchObj* pObj);
	
	//ǤᥤꥹȤpush_back롣
	void pushBackToMainList(SXBSchObj* pObj,bool doTidyUp);

	//󥯥νʣåԤ
	bool checkRedundancyJunction(SXBSchJunc* pObj);

	//磻䡼,Хη
	void tidyUpWireBus(SXBSchLine* pObj);

	//磻䡼,󥯥 ƥå1
	void tidyUpWireJunction_1(int opCount);
	//磻䡼,󥯥 ƥå2
	void tidyUpWireJunction_2(int opCount);
	//磻䡼,󥯥 ƥå3
	void tidyUpWireJunction_3(int opCount);


	//֤ɲÿǤɲ ֹ֤
	int addSelect(SXBSchObj* pObj);
	//ꤷƤ
	int select(const SPoint& pt);
	//ϰϤꤷƤ
	int select(const SRect& rc);
	int selectForDrag(const SRect& rc,bool bCutOffPinWire);




	//m_rcTempArea  m_ptTempSnapPoint ֥ȤΥꥹȤꤹ롣
	void setupRcTempArea();
	void setupRotateRect();

	
	
	//β
	//ɥȤѹäȤtrue֤
	bool resetSelect();
	//֥ȤϰϤ
	SRect tempArea(){return m_rcTempArea;}
	//֥ȤΥʥåץݥȤ
	SPoint tempSnapPoint(){return m_ptTempSnapPoint;}
	//
	void init();
	//ե뤫ɤ߹
	int readFile(const char* fname);
	int readFile(FILE* fp);
	//եؤν񤭹
	int writeFile(const char* fname);
	int writeFile(FILE* fp);




	//***** Խ *****

	//ԡ
	//ԡԤ줿Ȥtrue֤
	virtual bool copy(){return false;}
	//Žդ
	//ɥȤѹäȤtrue֤
	virtual bool paste(const SPoint&){return false;}
	//Žդǽ
	virtual bool canPaste(){return false;}

	//
	//ɥȤѹäȤtrue֤
	bool del();

	//ڤ
	//ɥȤѹäȤtrue֤
	bool cut();


	//Undo
	//ɥȤѹäȤtrue֤
	bool undo();

	//ԡǽ
	bool canCopy();
	//ǽ
	bool canDel();
	//ڤǽ
	bool canCut();
	//Undoǽ
	bool canUndo();

	//Attributeѹǽ?
	bool canAttribute();

	//Rotate
	//ɥȤѹäȤtrue֤
	bool rotate();
	//Mirror
	//ɥȤѹäȤtrue֤
	bool mirror();

	//Rotateǽ
	bool canRotate();
	//Mirrorǽ
	bool canMirror();


	

	//쥤䡼ΰư
	bool moveToLayer(int nLayer);
	unsigned int visibleLayer(){return m_visibleLayer;}
	void setVisibleLayer(unsigned int n){m_visibleLayer=n&0xff;}
	int editLayer(){return m_editLayer;}
	void setEditLayer(int n){if(n>=0&&n<8)m_editLayer=n;}




	//ֹ֤
	int opCount(){return m_nOpCount;}
	//Ťǡκ
	void delOldData(int nOpCount);
	//ꤷɸǡξ夫ɤ
	int isOnTempData(const SPoint& pt);
	//ǡư
	void moveTempData(int offsetx,int offsety);
};

#endif  //#ifndef XBSCHDOC_H