/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#ifndef XBSCHVIEW_H
#define XBSCHVIEW_H

#include <qwidget.h>
#include <q3scrollview.h>
#include <qclipboard.h>
#include <qbitmap.h>
#include <qtimer.h>
//Added by qt3to4:
#include <QPixmap>
#include <QMouseEvent>
#include <QWheelEvent>
#include <QResizeEvent>
#include <QPrinter>


//#include <qcursor.h>
#include "xbsch.h"
#include "xbschdocsch.h"
#include "xbschfont.h"
#include "xbschpattern.h"

//class SXBSchDoc;
class SXBSchObj;
class QPainter;
class QCursor;

class SXBSchLabel;
class SXBSchComment;
class SXBSchComponent;
class SXBSchTag;



//class QSize;
//class QRect;
//class QPoint;

#define MAX_SHEET_WIDTH 3000
#define MAX_SHEET_HEIGHT 2000

class SXBSchView: public Q3ScrollView
{
    Q_OBJECT
public:

	enum MOVE_OPTION
	{
		MOVE_OPTION_COMPONENT_NAME	=1,
		MOVE_OPTION_COMPONENT_NUM	=2
	};


	SXBSchView(QWidget* parent);
	~SXBSchView();
	SXBSchDocSch* Document(){return m_pDoc;}

	void print(QPrinter*  pPrinter);	
//	void print(QPainter*  p, int dpi);
	
	//ɽ˴ؤ
	void RefreshView();
//	{
//				updateViewBuffer(true);
//				viewport()->update();}


	//Խ˴ؤ
	//ԡ
	void copy();
	//å
	void cut();
	//ڡ
	void paste();
	//
	void del();
	//UNDO
	void undo();
	//Attribute
	void attribute();
	//Rotate
	void rotate();
	//Mirror
	void mirror();
	//Invert()
	void invert();
	
	void moveToLayer(int nLayer);
	
	//ԡǽ
	bool canCopy(){ return m_pDoc->canCopy() ;}
	//Žդǽ
	bool canPaste(){ return m_pDoc->canPaste() ;}
	//ǽ
	bool canDel(){ return m_pDoc->canDel() ;}
	//ڤǽ
	bool canCut(){ return m_pDoc->canCut() ;}
	//Undoǽ
	bool canUndo(){ return m_pDoc->canUndo() ;}
	//Attributeѹǽ?
	bool canAttribute(){ return m_pDoc->canAttribute() ;}
	//Rotateǽ
	bool canRotate(){ return m_pDoc->canRotate() ;}
	//Mirrorǽ
	bool canMirror(){ return m_pDoc->canMirror() ;}

	//쥤䡼ΰưǽ
	bool canMoveToLayer(int nLayer);
	
	
	unsigned visibleLayer();
	void setVisibleLayer(unsigned n);
	int activeLayer();
	void setActiveLayer(int n);
	bool darkenNonActiveLayer();
	void setDarkenNonActiveLayer(bool f);
	
	
	

	//ġ˴Ϣ᥽å
	bool setToolMode(BSCH_TOOL_MODE mode);
	BSCH_TOOL_MODE toolMode(){return m_toolmode;}

	//åɽ˴Ϣ᥽å
	void setDisplayGrid(bool display);
	bool displayGrid(){return m_bDisplayGrid;}
	//ʥåפξ֤˴Ϣ᥽å
	void setSnapGrid(bool snap);
	bool snapGrid(){return m_bSnapGrid;}

	//ȥεư
	void resize();
	//ȥ
	void SetSheetSize(const QSize& size);
	//ȥμ
	QSize SheetSize();
	
	//ե¸
	int save(const QString& fname);
	//ե뤫ɤ߹
	int load(const QString& fname);
	//᡼եν
	bool exportImage(const QString& fname);

	//Ǹ¸ΤȤѹäɤ֤
	bool isDirty(){return m_pDoc->isDirty();}
	//̥֥ȤĤǤ⤢false֤
	bool isEmpty(){return m_pDoc->isEmpty();}

	//ե졼ǡȤ˥ǥեȥեȤ
	void setDefaultFont();
//	//ե졼ǡȤ˥⡼եȤ
//	void setSmallFont(bool updateview=true);

	void execLabelAttributeDlg(SXBSchLabel* pobj);			//٥Υȥӥ塼ѹư
	void execTagAttributeDlg(SXBSchTag* pobj);				//Υȥӥ塼ѹư
	void execComponentAttributeDlg(SXBSchComponent* pobj);	//ʤΥȥӥ塼ѹư
	void execCommentAttributeDlg(SXBSchComment* pObj);		//ȤΥȥӥ塼ѹư

//	SXBSchView();

//public slots:
//	void setContentsPos ( int x, int y ); 

//protected slots:
//	void scrollBuffer(int x,int y);
	
	//।󡦥
public:	
	bool CanZoomIn();
	bool CanZoomOut();
	void ZoomIn(bool menucommand);
	void ZoomOut(bool menucommand);
private:	
	enum{
		MAX_ZOOM = 4
			   };
	void setZoomValue();
	int m_nZoom;			//m_nZoomȤˤơsetZoomValue()ǡm_viewScalem_viewScaleMulꤹ롣	
	int  m_viewScale;			//̾Ψ
	int  m_viewScaleMul;		//Ψ
	
	
	

private:
	QPixmap m_viewBuffer;			//ѥХåե
	
	bool m_fEditHighLight;


	SXBSchDocSch* m_pDoc;			//ɥȤؤΥݥ
	BSCH_TOOL_MODE m_toolmode;	//ߤġΥ⡼
	bool m_bDisplayGrid;			//åɤɽ
	bool m_bSnapGrid;				//åɤؤΥʥåפξ

	bool m_bTimer;					//ޡƯ
	bool m_bLButtonDown;			//ܥβ
	bool m_bDrawSelectFrame;		//Ȥե饰
	bool m_bDrawTempLine;			//磻䡼Хˤ褹벾ե饰
	int  m_nTempLineOrder;			//磻䡼Хˤƿʿʤ1ľʤ-1̤ʤ0
	
	bool m_bInhibitPlaceObject;		//2003/10/26 줬trueΤȤޥ꡼Υ֥Ȥ֤ػߤ롣
	bool m_bReserveAttribute;		//2003/10/26 줬trueΤȤޥ꡼˥ȥӥ塼Ȥ¹Ԥ롣
	
	QPoint m_ptLastMoveAtContents;	//뤬ǸưȤviewportɸ
	QPoint m_ptLastMoveAtSheet;		//뤬ǸưȤsheetɸ
	QPoint m_ptLButtonDownAtSheet;	//ܥ󤬲줿Ȥsheetɸ
	QPoint m_ptLastMoveTempAtSheet;	//ǡǸư

	int  m_nAutoScrollX;			//ưΥ
	int  m_nAutoScrollY;			//ưΥ
	SXBSchObj* m_pCursorObj;		//դޤȤ̥֥
	int	 m_moveOption;				//ưƤΤꤹ륪ץ

	QCursor* m_pCurStd;
	QCursor* m_pCurMov;

	bool m_bCompleteDrawTemp;
	QTimer m_timerTempDraw;

	int m_oldContentsX;
	int m_oldContentsY;
	int m_oldOpCount;
	int m_oldViewScale;
	int m_oldViewScaleMul;
	bool m_clearTempRect;

protected:
	//ɸѴ˴ؤ
	QPoint ContentsToSheet(const QPoint& point);	//ContentsκɸsheetɸؤѴ
	QRect  ContentsToSheet(const QRect& rc);		//ContentsκɸsheetɸؤѴ 	
	QPoint SheetToContents(const QPoint& point);	//sheetκɸContentsɸؤѴ 	
	QRect  SheetToContents(const QRect& rc);		//sheetκɸContentsɸؤѴ 	
	QPoint snapPoint(const QPoint& point);			//ǴΥåɤΰ֤֤ 	
	//ưΥ̤
	void setAutoScrollValue();

	void JumpTo(QPoint& jumpto);//̺ɸӥ塼濴ˤ

	void drawGrid(QPainter*p,const QRect& rcClip,const QColor& color);

	//ꥹȾΥǡ xbschdrawobject.cpp
	void drawMainXBSchObj(QPainter*p,unsigned  nMode,SRect* prcClip,bool darkenNonActive, int nScale, int nScaleMul);
	void drawTempXBSchObj(QPainter*p,unsigned  nMode,SRect* prcClip);

	

	//ե졼  								xbschdrawobject.cpp
	void drawSelectFrame(QPainter*p);
	//ǡΥե졼  						xbschdrawobject.cpp
	void drawTempDataFrame(QPainter*p);
	//ˤĤޤȤ̥֥Ȥ 		xbschdrawobject.cpp 	
	void drawCursorObj(QPainter*p);
	//		  								xbschdrawobject.cpp
	void drawTempLine(QPainter*p);

	void resizeBuffer(int w,int h);

	/////////////////////////////////////////
	//  ֤˴Ϣ
	//٥
	bool placeLabel(const QPoint&);		//٥
	bool placeTag(const QPoint&);		//
	bool placeComponent(const QPoint&);	//ʤ
	bool placeComment(const QPoint& point);	//Ȥ

signals:
	void cursorMove(int x,int y);
	void toolChange();

private slots:
	//void whenScroll(int x,int y);
	void onScrollTimer();
	void onTimerDrawTemp();
	//void clipboardChanged();

protected:
	void contentsMousePressEvent(QMouseEvent*);
	void contentsMouseReleaseEvent(QMouseEvent *);
	void contentsMouseMoveEvent(QMouseEvent *me);
	void contentsMouseDoubleClickEvent ( QMouseEvent * );
	void resizeEvent ( QResizeEvent * );
	//void viewportPaintEvent (QPaintEvent *);

	void contentsWheelEvent ( QWheelEvent *e );

	//													xbschdrawobject.cpp
	void drawContents(QPainter*p,int clipx,int clipy, int clipw, int cliph );
	//drawContentsˤȤʤХåեκ
	//Ϥ̵ꥢκɸϥƥĺɸ
//	void updateViewBuffer(int clipx,int clipy, int clipw, int cliph );
	void updateViewBuffer(bool bForceUpdate = false);//int clipx,int clipy, int clipw, int cliph );
	//Хåեκ
	//Ϥ̵ꥢκɸϥƥĺɸ
	void drawBuffer(int x,int y,int clipx,int clipy, int clipw, int cliph );

	void viewportResizeEvent(QResizeEvent * );
};


#endif
