/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.utils.URI;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class URIReferenceDatatypeValidator
extends AbstractDatatypeValidator {
    private DatatypeValidator fBaseValidator = null;
    private int fLength = 0;
    private int fMaxLength = Integer.MAX_VALUE;
    private int fMinLength = 0;
    private String fPattern = null;
    private Vector fEnumeration = null;
    private int fFacetsDefined = 0;
    private RegularExpression fRegex = null;

    public URIReferenceDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public URIReferenceDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.setBasetype(datatypeValidator);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = (String)enumeration.nextElement();
                if (string2.equals("length")) {
                    ++this.fFacetsDefined;
                    string = (String)hashtable.get(string2);
                    try {
                        this.fLength = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("Length value '" + string + "' is invalid.");
                    }
                    if (this.fLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("Length value '" + string + "'  must be a nonNegativeInteger.");
                }
                if (string2.equals("minLength")) {
                    this.fFacetsDefined += 2;
                    string = (String)hashtable.get(string2);
                    try {
                        this.fMinLength = Integer.parseInt(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + string + "' is invalid.");
                    }
                }
                if (string2.equals("maxLength")) {
                    this.fFacetsDefined += 4;
                    string = (String)hashtable.get(string2);
                    try {
                        this.fMaxLength = Integer.parseInt(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + string + "' is invalid.");
                    }
                }
                if (string2.equals("pattern")) {
                    this.fFacetsDefined += 8;
                    this.fPattern = (String)hashtable.get(string2);
                    if (this.fPattern == null) continue;
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                if (string2.equals("enumeration")) {
                    this.fFacetsDefined += 16;
                    this.fEnumeration = (Vector)hashtable.get(string2);
                    continue;
                }
                throw new InvalidDatatypeFacetException();
            }
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fFacetsDefined & 4) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                }
                if ((this.fFacetsDefined & 2) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                }
            }
            if ((this.fFacetsDefined & 6) != 0 && this.fMinLength > this.fMaxLength) {
                throw new InvalidDatatypeFacetException("Value of maxLength = " + this.fMaxLength + "must be greater that the value of minLength" + this.fMinLength);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public int compare(String string, String string2) {
        return 0;
    }

    public Hashtable getFacets() {
        return null;
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        Object var3_3 = null;
        URI uRI = null;
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
            throw new InvalidDatatypeValueException("Value '" + string + "' does not match regular expression facet" + this.fPattern);
        }
        try {
            if (string.trim().length() != 0) {
                uRI = new URI(string);
            }
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidDatatypeValueException("Value '" + string + "' is a Malformed URI ");
        }
        return null;
    }
}

