/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import com.ibm.ivj.util.base.ImportCodeSpec;
import com.ibm.ivj.util.base.IvjException;
import com.ibm.ivj.util.base.Project;
import com.ibm.ivj.util.base.Type;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ide.VAJUtil;
import org.apache.tools.ant.types.FileSet;

public class VAJImport
extends Task {
    protected Vector filesets = new Vector();
    protected boolean importSources = true;
    protected boolean importResources = true;
    protected boolean importClasses = false;
    protected String importProject = null;
    protected Project vajproject = null;

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void execute() throws BuildException {
        if (this.filesets.size() == 0) {
            throw new BuildException("At least one fileset is required!");
        }
        if (this.importProject == null || "".equals(this.importProject)) {
            throw new BuildException("The VisualAge for Java Project name is required!");
        }
        this.vajproject = this.getVAJProject();
        if (this.vajproject == null) {
            try {
                this.vajproject = VAJUtil.getWorkspace().createProject(this.importProject, true);
            }
            catch (IvjException ivjException) {
                throw VAJUtil.createBuildException("Error while creating Project " + this.importProject + ": ", ivjException);
            }
        }
        Enumeration enumeration = this.filesets.elements();
        while (enumeration.hasMoreElements()) {
            this.importFileset((FileSet)enumeration.nextElement());
        }
    }

    protected Project getVAJProject() {
        Project project = null;
        Project[] projectArray = VAJUtil.getWorkspace().getProjects();
        int n = 0;
        while (n < projectArray.length) {
            Project project2 = projectArray[n];
            if (project2.getName().equals(this.importProject)) {
                project = project2;
                break;
            }
            ++n;
        }
        return project;
    }

    protected void importFileset(FileSet fileSet) {
        Type[] typeArray;
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
        if (directoryScanner.getIncludedFiles().length == 0) {
            return;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        Object[] objectArray3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Importing ");
        String string = "";
        ImportCodeSpec importCodeSpec = new ImportCodeSpec();
        importCodeSpec.setDefaultProject(this.vajproject);
        this.scan(fileSet.getDir(this.project), directoryScanner.getIncludedFiles(), vector, vector2, vector3);
        if (this.importClasses) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            importCodeSpec.setClassFiles((String[])objectArray);
            if (objectArray.length > 0) {
                this.logFiles(vector, "class");
                stringBuffer.append(objectArray.length);
                stringBuffer.append(" class ");
                stringBuffer.append(objectArray.length > 1 ? "files" : "file");
                string = ", ";
            }
        }
        if (this.importSources) {
            objectArray2 = new String[vector2.size()];
            vector2.copyInto(objectArray2);
            importCodeSpec.setJavaFiles((String[])objectArray2);
            if (objectArray2.length > 0) {
                this.logFiles(vector2, "source");
                stringBuffer.append(string);
                stringBuffer.append(objectArray2.length);
                stringBuffer.append(" source ");
                stringBuffer.append(objectArray2.length > 1 ? "files" : "file");
                string = ", ";
            }
        }
        if (this.importResources) {
            typeArray = fileSet.getDir(this.project).getAbsolutePath();
            objectArray3 = new String[vector3.size()];
            vector3.copyInto(objectArray3);
            importCodeSpec.setResourcePath((String)typeArray);
            importCodeSpec.setResourceFiles((String[])objectArray3);
            if (objectArray3.length > 0) {
                this.logFiles(vector3, "resource");
                this.log("  (relative to resource path '" + (String)typeArray + "')", 3);
                stringBuffer.append(string);
                stringBuffer.append(objectArray3.length);
                stringBuffer.append(" resource ");
                stringBuffer.append(objectArray3.length > 1 ? "files" : "file");
            }
        }
        stringBuffer.append(" into the ");
        stringBuffer.append(this.importProject);
        stringBuffer.append(" project.");
        this.log(stringBuffer.toString());
        try {
            typeArray = VAJUtil.getWorkspace().importData(importCodeSpec);
            if (typeArray == null) {
                throw new BuildException("Unable to import into Workspace!");
            }
        }
        catch (IvjException ivjException) {
            VAJUtil.createBuildException("Error while importing into Workspace: ", ivjException);
        }
    }

    protected void logFiles(Vector vector, String string) {
        this.log(String.valueOf(string) + " files found for import:", 3);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.log("    " + enumeration.nextElement(), 3);
        }
    }

    protected void scan(File file, String[] stringArray, Vector vector, Vector vector2, Vector vector3) {
        int n = 0;
        while (n < stringArray.length) {
            String string = new File(file, stringArray[n]).getAbsolutePath();
            if (string.endsWith(".java") || string.endsWith(".JAVA")) {
                vector2.addElement(string);
            } else if (string.endsWith(".class") || string.endsWith(".CLASS")) {
                vector.addElement(string);
            } else {
                vector3.addElement(stringArray[n]);
            }
            ++n;
        }
    }

    public void setImportClasses(boolean bl) {
        this.importClasses = bl;
    }

    public void setImportResources(boolean bl) {
        this.importResources = bl;
    }

    public void setImportSources(boolean bl) {
        this.importSources = bl;
    }

    public void setVajproject(String string) {
        this.importProject = string;
    }
}

