/*************************************************************************
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2008 by Kohei Yoshida.
 *    1039 Kingsway Dr., Apex, NC 27502, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "numeric/penalty.hxx"
#include "numeric/nlpmodel.hxx"
#include <string>
#include <vector>

using ::std::string;
using ::std::vector;

namespace scsolver { namespace numeric { namespace nlp {

struct PenaltyImpl
{

    const BaseFuncObj*  pObjectiveFunc;
    vector<Constraint>  Constraints;
    double              Factor;

    PenaltyImpl();
    PenaltyImpl(const PenaltyImpl& r);
};

PenaltyImpl::PenaltyImpl() :
    pObjectiveFunc(NULL), 
    Factor(1.0)
{
}

PenaltyImpl::PenaltyImpl(const PenaltyImpl& r) :
    pObjectiveFunc(r.pObjectiveFunc), 
    Constraints(r.Constraints),
    Factor(r.Factor)
{
}

// ----------------------------------------------------------------------------

Penalty::Penalty() :
    BaseFuncObj(),
    mpImpl(new PenaltyImpl)
{
}

Penalty::Penalty(const Penalty& r) :
    BaseFuncObj(*this),
    mpImpl(new PenaltyImpl(*r.mpImpl))
{
}

Penalty::~Penalty()
{
}

double Penalty::eval()
{
    return 0.0;
}

const string Penalty::getFuncString() const
{
    string str("");
    return str;
}

void Penalty::initFromModel(Model* pModel)
{
    mpImpl->pObjectiveFunc = pModel->getFuncObject();
    const vector<Constraint>& cons = pModel->getAllConstraints();
    mpImpl->Constraints.assign(cons.begin(), cons.end());
}

void Penalty::setConstraintFactor(double factor)
{
    mpImpl->Factor = factor;
}


}}}
