/****************************************************************************
** Simple gestion du drag and drop
** Créé par Anacr0x : anacr0x@free.fr
**
** Sous licence GPL v2 ou plus
****************************************************************************/

#ifndef MYTREEWIDGET_H
#define MYTREEWIDGET_H

#include <QtCore>
#include <QtGui>
#include <QtNetwork>
#include "BasicTreeWidget/basictreewidget.h"

class MyTreeWidgetItem;

/*************************************************************************/
//! Gère le drag and drop et simplifie la gestion des items

/*! MyTreeWidget permet simplement de gérer les signaux necessaires au drag
   and drop de Qt. De plus, il possède les colonnes et attributs nécessaires
   à l'utilisation des MyTreeWidgetItem. */
/*************************************************************************/

class MyTreeWidget:public BasicTreeWidget
{
	Q_OBJECT

public:
	/*! Les différentes sélections possibles */
	enum Select { AllFiles, AllDirs, AllFilesAndDirs };

	/*! Le constructeur : ajoute les colonnes nécessaires et initialise quelques paramètres */
	MyTreeWidget (QWidget * parent);

	/*! Redimensionne automatiquement les colonnes (après toute la mise à jour) */
	void autoResize();

public slots:
	/*! Sélectionne les fichiers selon le mode choisi */
	void slotSelect (int select);

	/*! Sélectionne tous les fichiers */
	inline void slotSelectFiles ()
	{
		slotSelect (MyTreeWidget::AllFiles);
	}

	/*! Sélectionne tous les dossiers */
	inline void slotSelectDirs ()
	{
		slotSelect (MyTreeWidget::AllDirs);
	}

	/*! Sélectionne tous les fichiers et les dossiers */
	inline void slotSelectFilesAndDirs ()
	{
		slotSelect (MyTreeWidget::AllFilesAndDirs);
	}

signals:
	/*! Si un drag est accepté et si n doit lancer un transfert */
	void startDownloadOrUpload (const QString &destDir);

private:
	/*! Utilisé pour lancer le drag */
	void mouseMoveEvent (QMouseEvent *event);

	/*! Permet d'accepter le drag */
	void dragEnterEvent (QDragEnterEvent *event);

	/*! Permet de lancer le download/upload en fonction du drop */
	void dropEvent (QDropEvent *event);
};


/*************************************************************************/
//! Affiche tous les fichiers avec leurs spécifications

/*! MyTreeWidgetItem permet d'associer une icône prédéfinie selon le type de
   fichier.\n
   \n
   Le nom du fichier est affiché dans la 1ere colonne, la taille dans la
   seconde, la date dans la troisième, les droits dans la quatrième et le
   type dans la cinquième. */
/*************************************************************************/

class MyTreeWidgetItem:public QTreeWidgetItem
{
private:
	/*! Stock l'état général : dossier ou fichier */
	bool DirOrNot;

public:
	/*! Assigne à chaque dossier/fichier une icone selon le type\n
	   \warning size doit être en octet et non en Ko, Mo... */
	MyTreeWidgetItem (QTreeWidget * parent, bool dir, const QString & name, const QString & size = "", const QString &lastModified = "", const QString & droits = "", const QString & proprietaire = "");

	/*! Les différents types généraux de dossiers/fichiers possibles */
	enum State
	{
		Root, Refresh, CdUp, Dir, DirLocked, File
	};

	/*! Donne le type général du dossier/fichier */
	State state;

	/*! Les différents types détaillés de fichiers possibles */
	enum FileState
	{
		None, Image, Video, Audio, Archive, Texte, Document, Internet, Autre
	};

	/*! Donne le type précis du fichier */
	FileState fileState;

	/*! Retourne true s'il s'agit d'un dossier */
	inline bool isDir ()
	{
		return DirOrNot;
	}

	/*! Retourne true s'il s'agit d'un fichier/dossier simple : ie != ".", "..", "/" etc... */
	static bool isSimple (const QString & filename);

	/*! Retourne true s'il s'agit d'un fichier/dossier simple : ie != ".", "..", "/" etc... */
	inline bool isSimple ()
	{
		return isSimple (text (0));
	}

	/*! Retourne le type général du dossier/fichier */
	inline State getState ()
	{
		return state;
	}

	/*! Retourne le type précis du fichier */
	inline FileState getFileState ()
	{
		return fileState;
	}
};

#endif
