/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGDASHBOARD2PLUGINWIDGET_H
#define SKGDASHBOARD2PLUGINWIDGET_H
/** @file
 * Display a summary of your information
*
* @author Siddharth SHARMA
*/
#include "ui_skgdashboard2pluginwidget_base.h"
#include "skgtabpage.h"
#include <plasma/containment.h>
#include <plasma/view.h>

/**
 * Display a summary of your information
 */


class SKGDashboard2PluginWidget : public SKGTabPage
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    SKGDashboard2PluginWidget ( SKGDocument* iDocument );

    /**
     * Default Destructor
     */
    virtual ~SKGDashboard2PluginWidget();

    /**
     * Get the current state
     * MUST BE OVERWRITTEN
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
//    virtual QString getState();

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
//    virtual void setState ( const QString& iState );

    /**
     * Get attribute name to save the default state
     * MUST BE OVERWRITTEN
     * @return attribute name to save the default state.
     */
//    virtual QString getDefaultStateAttribute();

    /**
     * Get the widget must be printed
     * @return a widget
     */
//    virtual QWidget* getWidgetForPrint();


protected:
    /**
     * Event filtering
     * @param object object
     * @param event event
     * @return In your reimplementation of this function, if you want to filter the event out, i.e. stop it being handled further, return true; otherwise return false.
     */
//    virtual bool eventFilter ( QObject *object, QEvent *event );
    /*
    private slots:
        void resizeContainment();
        void onAddWidget();
        void toggleImmutability();
    */
private:
//    Q_DISABLE_COPY ( SKGDashboard2PluginWidget );

//    Plasma::Corona* dashboardCorona;
//    QAction* lockAction;
    KParts::Part* plasmadashboard;
    Ui::skgdashboard2plugin_base ui;
//    Plasma::Containment* containment;
//    Plasma::View* view;
};

#endif // SKGDASHBOARD2PLUGINWIDGET_H
