/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * Display a summary of your information.
 *
 * @author Siddharth SHARMA
 *
 */

#include "skgdashboard2widgetwrapper.h"
#include "skgdashboard2applet.h"
#include "skgmainpanel.h"
#include "skgtraces.h"
#include "skginterfaceplugin.h"
#include <QGraphicsGridLayout>
#include <internalappletloader.h>
SKGDashboard2WidgetWrapper::SKGDashboard2WidgetWrapper(const QString& applet): QObject()
{
    loadApplet(applet);
}
Plasma::Applet* SKGDashboard2WidgetWrapper::loadApplet(const QString& appletName)
{

    SKGDashboard2Applet* applet;
    QString id=appletName;
    QStringList param=SKGServices::splitCSVLine ( id,'-' );

    SKGInterfacePlugin* db=SKGMainPanel::getMainPanel()->getPluginByName ( param.at ( 0 ) );
    if ( db )
    {
        SKGWidget* dbw=db->getDashboardWidget ( SKGServices::stringToInt ( param.at ( 1 ) ) );
        if ( dbw )
        {

            applet=new SKGDashboard2Applet(this, QVariantList());
            applet->setSKGWidget(dbw);
            applet->setData(12, id);
            //  containment->addApplet(applet, QPointF(-1,-1), false);

        }
    }

    return applet;
}

SKGDashboard2WidgetWrapper::~SKGDashboard2WidgetWrapper()
{

}
InternalAppletLoader::~InternalAppletLoader() {}

