/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGZOOMSELECTOR_H
#define SKGZOOMSELECTOR_H
/** @file
 * A zoom selector.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include "ui_skgzoomselector.h"
#include <QtDesigner/QDesignerExportWidget>
#include "skgbasegui_export.h"
/**
 * This file is a zoom selector.
 */
class SKGBASEGUI_EXPORT SKGZoomSelector : public QWidget
{
    Q_OBJECT
    /**
     * Value of the zoom
     */
    Q_PROPERTY ( int value READ value WRITE setValue USER true )

public:
    /**
     * Default Constructor
     * @param parent the parent
     */
    SKGZoomSelector ( QWidget *parent = 0 );

    /**
     * Default Destructor
     */
    virtual ~SKGZoomSelector();

public slots:
    /**
     * Get the value of the zoom
     * @return the value
     */
    virtual int value() const;

    /**
     * Set the value of the zoom
     * @param iValue the value
     */
    virtual void setValue ( int iValue );

signals:
    /**
     * Emitted when the value is changed
     * @param iValue the value
     */
    void changed(int iValue);

private slots:
    void onZoomInit();
    void onZoomIn();
    void onZoomOut();
    void onZoomChanged();

private:
    Ui::skgzoomselector ui;
};

#endif // SKGZOOMSELECTOR_H
