/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for bank management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgbankplugin.h"
#include "skgbankpluginwidget.h"
#include "skgbankboardwidget.h"
#include "skgbank_settings.h"
#include "skgmainpanel.h"
#include "skgaccountobject.h"
#include "skgtraces.h"
#include "skgdocumentbank.h"

#include <kactioncollection.h>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY ( SKGBankPluginFactory, registerPlugin<SKGBankPlugin>(); )
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN ( SKGBankPluginFactory ( "skrooge_bank", "skrooge_bank" ) )

SKGBankPlugin::SKGBankPlugin ( QObject* iParent, const QVariantList& /*iArg*/ )
        :SKGInterfacePlugin ( iParent ), currentBankDocument ( NULL )
{
    SKGTRACEIN ( 10, "SKGBankPlugin::SKGBankPlugin" );
}

SKGBankPlugin::~SKGBankPlugin()
{
    SKGTRACEIN ( 10, "SKGBankPlugin::~SKGBankPlugin" );
    currentBankDocument=NULL;
    reconciliateAction=NULL;
}

bool SKGBankPlugin::setupActions ( SKGDocument* iDocument, const QStringList& iArgument )
{
    SKGTRACEIN ( 10, "SKGBankPlugin::setupActions" );
    Q_UNUSED ( iArgument );
    currentBankDocument=dynamic_cast<SKGDocumentBank*>(iDocument);
    if (currentBankDocument==NULL) return false;

    setComponentData ( SKGBankPluginFactory::componentData() );
    setXMLFile ( "skrooge_bank.rc" );

    //Menu
    reconciliateAction = new KAction ( KIcon ( "skrooge_duplicate" ), i18nc ("Verb", "Reconcile..." ), this );
    connect ( reconciliateAction, SIGNAL ( triggered ( bool ) ), this, SLOT ( actionReconciliate() ) );
    actionCollection()->addAction ( QLatin1String ( "edit_reconciliate" ), reconciliateAction );
    reconciliateAction->setShortcut ( Qt::ALT+Qt::Key_R );

    if ( SKGMainPanel::getMainPanel() ) SKGMainPanel::getMainPanel()->registedGlobalAction ( "edit_reconciliate", reconciliateAction );
    return true;
}

void SKGBankPlugin::close()
{
    SKGTRACEIN ( 10, "SKGBankPlugin::close" );
}

int SKGBankPlugin::getNbDashboardWidgets()
{
    return 1;
}

QString SKGBankPlugin::getDashboardWidgetTitle ( int iIndex )
{
    if ( iIndex==0 ) return i18nc ( "Noun, a list of items","Accounts" );
    return "";
}

SKGWidget* SKGBankPlugin::getDashboardWidget ( int iIndex )
{
    if ( iIndex==0 ) return new SKGBankBoardWidget ( currentBankDocument );
    return NULL;
}

SKGTabPage* SKGBankPlugin::getWidget()
{
    SKGTRACEIN ( 10, "SKGBankPlugin::getWidget" );
    return new SKGBankPluginWidget ( currentBankDocument );
}

QWidget* SKGBankPlugin::getPreferenceWidget()
{
    SKGTRACEIN ( 10, "SKGBankPlugin::getPreferenceWidget" );
    /*        QWidget* widget=new QWidget();
            ui.setupUi(widget);*/

    return NULL;
}

KConfigSkeleton* SKGBankPlugin::getPreferenceSkeleton()
{
    return skgbank_settings::self();
}

QString SKGBankPlugin::title() const
{
    return i18nc("Noun", "Bank and Account" );
}

QString SKGBankPlugin::icon() const
{
    return "kwalletmanager";
}

QString SKGBankPlugin::toolTip () const
{
    return i18nc("Noun", "Bank and account management" );
}

QStringList SKGBankPlugin::tips() const
{
    QStringList output;
    output.push_back(i18nc("Description of a tips", "<p>... you can associate a logo with your banks.</p>" ) );
    return output;
}

int SKGBankPlugin::getOrder() const
{
    //Must be one of the first
    return 10;
}

bool SKGBankPlugin::isInContext() const
{
    return true;
}

void SKGBankPlugin::refresh()
{
    SKGTRACEIN ( 10, "SKGBankPlugin::refresh" );
    if ( currentBankDocument && SKGMainPanel::getMainPanel() )
    {
        SKGObjectBase::SKGListSKGObjectBase selection=SKGMainPanel::getMainPanel()->getSelectedObjects();
        if ( selection.count() >0 )
        {
            bool onAccount= ( selection.at ( 0 ).getRealTable() =="account" );
            if ( reconciliateAction ) reconciliateAction->setEnabled ( onAccount );
        }
        else
        {
            if ( reconciliateAction ) reconciliateAction->setEnabled ( false );
        }
    }
}

void SKGBankPlugin::actionReconciliate()
{
    if ( currentBankDocument && SKGMainPanel::getMainPanel() )
    {
        QApplication::setOverrideCursor ( QCursor ( Qt::WaitCursor ) );

        //Open in operation plugin
        SKGObjectBase::SKGListSKGObjectBase selection=SKGMainPanel::getMainPanel()->getSelectedObjects();
        int nb=selection.count();
        for ( int i=0; i<nb; ++i )
        {
            SKGAccountObject accountObj=selection[i];

            QDomDocument doc ( "SKGML" );
            doc.setContent ( currentBankDocument->getParameter ( "SKGOPERATION_DEFAULT_PARAMETERS" ) );
            QDomElement root = doc.documentElement();
            if ( root.isNull() )
            {
                root=doc.createElement ( "parameters" );
                doc.appendChild ( root );
            }

            root.setAttribute ( "account", accountObj.getName() );
            root.setAttribute ( "modeInfoZone", "1" );
            root.setAttribute ( "currentPage", "-1" );
            SKGMainPanel::getMainPanel()->openPage ( SKGMainPanel::getMainPanel()->getPluginByName ( "Skrooge operation plugin" ), -1, doc.toString() );
        }
        QApplication::restoreOverrideCursor();
    }
}

#include "skgbankplugin.moc"
