/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A skrooge plugin for monthlu report
 *
 * @author Stephane MANKOWSKI
 */
#include "skgmonthlyplugin.h"
#include "skgmonthlypluginwidget.h"
#include "skgmonthlyboardwidget.h"
#include "skgmonthly_settings.h"
#include "skgtraces.h"
#include "skgdocumentbank.h"

#include <kactioncollection.h>
#include <kstandardaction.h>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGMonthlyPluginFactory, registerPlugin<SKGMonthlyPlugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGMonthlyPluginFactory("skrooge_monthly", "skrooge_monthly"))

SKGMonthlyPlugin::SKGMonthlyPlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
    SKGTRACEIN(10, "SKGMonthlyPlugin::SKGMonthlyPlugin");
}

SKGMonthlyPlugin::~SKGMonthlyPlugin()
{
    SKGTRACEIN(10, "SKGMonthlyPlugin::~SKGMonthlyPlugin");
    currentBankDocument=NULL;
}

bool SKGMonthlyPlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
    SKGTRACEIN(10, "SKGMonthlyPlugin::setupActions");
    Q_UNUSED(iArgument);
    if (dynamic_cast<SKGDocumentBank*>(iDocument)==NULL) return false;

    currentBankDocument=iDocument;

    setComponentData( SKGMonthlyPluginFactory::componentData() );
    setXMLFile("skrooge_monthly.rc");

    //Create yours actions here
    return true;
}

void SKGMonthlyPlugin::refresh()
{
    SKGTRACEIN(10, "SKGMonthlyPlugin::refresh");
}

void SKGMonthlyPlugin::close()
{
    SKGTRACEIN(10, "SKGMonthlyPlugin::close");
}

int SKGMonthlyPlugin::getNbDashboardWidgets()
{
    SKGTRACEIN ( 1, "SKGMonthlyPlugin::getNbDashboardWidgets" );
    return 2;
}

QString SKGMonthlyPlugin::getDashboardWidgetTitle ( int iIndex )
{
    SKGTRACEIN ( 1, "SKGMonthlyPlugin::getDashboardWidgetTitle" );
    if ( iIndex==0 ) return i18nc ("Report header",  "5 main categories of expenditure" );
    else if ( iIndex==1 ) return i18nc ("Report header",  "5 main variations" );
    return "";
}

SKGWidget* SKGMonthlyPlugin::getDashboardWidget ( int iIndex )
{
    SKGWidget* w=new SKGMonthlyBoardWidget ( currentBankDocument );

    QDomDocument doc ( "SKGML" );
    QDomElement root = doc.createElement ( "parameters" );
    doc.appendChild ( root );
    root.setAttribute ( "mode", SKGServices::intToString(iIndex) );

    w->setState(doc.toString());
    return w;
}

SKGTabPage* SKGMonthlyPlugin::getWidget()
{
    SKGTRACEIN(10, "SKGMonthlyPlugin::getWidget");
    return new SKGMonthlyPluginWidget(currentBankDocument);
}

QWidget* SKGMonthlyPlugin::getPreferenceWidget()
{
    SKGTRACEIN(10, "SKGMonthlyPlugin::getPreferenceWidget");
    /* QWidget* widget=new QWidget();
     ui.setupUi(widget);
     return widget;*/
    return NULL;
}

KConfigSkeleton* SKGMonthlyPlugin::getPreferenceSkeleton()
{
    return skgmonthly_settings::self();
}

QString SKGMonthlyPlugin::title() const
{
    return toolTip();
}

QString SKGMonthlyPlugin::icon() const
{
    return "skrooge_monthly_report";
}

QString SKGMonthlyPlugin::toolTip () const
{
    return i18nc("A tool tip", "Monthly report");
}

int SKGMonthlyPlugin::getOrder() const
{
    return 50;
}

QStringList SKGMonthlyPlugin::tips() const
{
    QStringList output;
    output.push_back(i18nc("Description of a tips", "<p>... you can generate a monthly report.</p>"));
    return output;
}

bool SKGMonthlyPlugin::isInContext() const
{
    return true;
}

#include "skgmonthlyplugin.moc"
