/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for bank management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgreportboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgmainpanel.h"
#include "skgreportpluginwidget.h"

SKGReportBoardWidget::SKGReportBoardWidget ( SKGDocumentBank* iDocument )
        : SKGWidget ( iDocument )
{
    SKGTRACEIN ( 10, "SKGReportBoardWidget::SKGReportBoardWidget" );

    ui.setupUi ( this );

    graph=new SKGReportPluginWidget ( iDocument, true );
    ui.gridLayout->addWidget ( graph, 0, 0, 1, 1 );
    this->setMinimumSize ( 200, 200 );

    //Refresh
    connect ( ( const QObject* ) getDocument(), SIGNAL ( tableModified ( QString, int ) ), this, SLOT ( dataModified ( QString, int ) ), Qt::QueuedConnection );
}

SKGReportBoardWidget::~SKGReportBoardWidget()
{
    SKGTRACEIN ( 10, "SKGReportBoardWidget::~SKGReportBoardWidget" );
    graph=NULL;
}

QString SKGReportBoardWidget::getState()
{
    return ( graph ? graph->getState() : "" );
}

void SKGReportBoardWidget::setState ( const QString& iState )
{
    if ( graph ) graph->setState ( iState );
    dataModified ( "", 0 );
}

void SKGReportBoardWidget::dataModified ( const QString& iTableName, int iIdTransaction )
{
    SKGTRACEIN ( 10, "SKGReportBoardWidget::dataModified" );
    Q_UNUSED ( iIdTransaction );
    if ( iTableName=="operation" || iTableName.isEmpty() )
    {
        int nbAccount=0;
        SKGObjectBase::getNbObjects ( getDocument(), "account", "", nbAccount );
        if ( parentWidget() ) setVisible ( nbAccount>0 );
    }
}

void SKGReportBoardWidget::onOpen()
{
    ui.kGroup->setChecked(true);
    SKGMainPanel::getMainPanel()->openPage ( SKGMainPanel::getMainPanel()->getPluginByName ( "Skrooge report plugin" ), -1, getState() );
}

#include "skgreportboardwidget.moc"
