#!/bin/sh
source ${builddir:-.}/slapd.sh
showdiff()
{
	base1=`basename "$1"`
	base2=`basename "$2"`
	diff -u "$@" | \
	sed -r -e "s,^--- .*/(.*),--- \1,g" -e "s,^\+\+\+ .*/(.*),+++ \1,g"
}
for subdir in "$@" ; do
	pushd $subdir > /dev/null
	TEST="$subdir"
	precmd=
	if test -x edit-dse-config.sh ; then
		precmd="$TESTDIR/$subdir/edit-dse-config.sh $BTESTDIR/config/dse.ldif"
	fi
	startslapd $TESTDIR/$subdir/dse.ldif $TESTDIR/$subdir/userRoot.ldif "$precmd"
	if test -x $TESTDIR/$subdir/before.sh ; then
		$TESTDIR/$subdir/before.sh > before.out 2>&1
		if test -r $TESTDIR/$subdir/before.txt ; then
			if ! cmp -s $TESTDIR/$subdir/before.txt before.out ; then
				echo `basename "$subdir"`:
				showdiff $TESTDIR/$subdir/before.txt before.out
				stopslapd
				exit 1
			fi
		fi
	fi
	if test -x $TESTDIR/$subdir/change.sh ; then
		$TESTDIR/$subdir/change.sh > change.out 2>&1
		if test -r $TESTDIR/$subdir/change.txt ; then
			if ! cmp -s $TESTDIR/$subdir/change.txt change.out ; then
				echo `basename "$subdir"`:
				showdiff $TESTDIR/$subdir/change.txt change.out
				stopslapd
				exit 1
			fi
		fi
	fi
	if test -x $TESTDIR/$subdir/after.sh ; then
		$TESTDIR/$subdir/after.sh > after.out 2>&1
		if test -r $TESTDIR/$subdir/after.txt ; then
			if ! cmp -s $TESTDIR/$subdir/after.txt after.out ; then
				echo `basename "$subdir"`:
				showdiff $TESTDIR/$subdir/after.txt after.out
				stopslapd
				exit 1
			fi
		fi
	fi
	stopslapd
	popd > /dev/null
	if test -s $TESTDIR/$subdir/description.txt ; then
		echo `basename $subdir`" ("`head -n 1 $TESTDIR/$subdir/description.txt`")": OK
	else
		echo `basename $subdir`: OK
	fi
done
exit 0
