/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.lang.ObjectUtil;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.AggregateOperator;
import org.openrdf.query.algebra.Count;
import org.openrdf.query.algebra.Group;
import org.openrdf.query.algebra.GroupElem;
import org.openrdf.query.algebra.Max;
import org.openrdf.query.algebra.Min;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupIterator
extends CloseableIteratorIteration<BindingSet, QueryEvaluationException> {
    private final EvaluationStrategy strategy;
    private final BindingSet parentBindings;
    private final Group group;
    private boolean ordered = false;

    public GroupIterator(EvaluationStrategy strategy, Group group, BindingSet parentBindings) throws QueryEvaluationException {
        this.strategy = strategy;
        this.group = group;
        this.parentBindings = parentBindings;
        super.setIterator(this.createIterator());
    }

    private Iterator<BindingSet> createIterator() throws QueryEvaluationException {
        Collection<Entry> entries;
        AbstractCollection bindingSets;
        if (this.ordered) {
            bindingSets = new ArrayList();
            entries = this.buildOrderedEntries();
        } else {
            bindingSets = new HashSet();
            entries = this.buildUnorderedEntries();
        }
        for (Entry entry : entries) {
            Value value;
            QueryBindingSet sol = new QueryBindingSet(this.parentBindings);
            for (String name : this.group.getGroupBindingNames()) {
                value = entry.getPrototype().getValue(name);
                if (value == null) continue;
                sol.setBinding(name, value);
            }
            for (GroupElem ge : this.group.getGroupElements()) {
                value = this.processAggregate(entry.getSolutions(), ge.getOperator());
                if (value == null) continue;
                sol.setBinding(ge.getName(), value);
            }
            bindingSets.add(sol);
        }
        return bindingSets.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Entry> buildOrderedEntries() throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.strategy.evaluate(this.group.getArg(), this.parentBindings);
        try {
            ArrayList<Entry> orderedEntries = new ArrayList<Entry>();
            HashMap<Key, Entry> entries = new HashMap<Key, Entry>();
            while (iter.hasNext()) {
                BindingSet bindingSet = (BindingSet)iter.next();
                Key key = new Key(bindingSet);
                Entry entry = (Entry)entries.get(key);
                if (entry == null) {
                    entry = new Entry(bindingSet);
                    entries.put(key, entry);
                    orderedEntries.add(entry);
                }
                entry.addSolution(bindingSet);
            }
            ArrayList<Entry> arrayList = orderedEntries;
            return arrayList;
        }
        finally {
            iter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Entry> buildUnorderedEntries() throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.strategy.evaluate(this.group.getArg(), this.parentBindings);
        try {
            HashMap<Key, Entry> entries = new HashMap<Key, Entry>();
            while (iter.hasNext()) {
                BindingSet sol = (BindingSet)iter.next();
                Key key = new Key(sol);
                Entry entry = (Entry)entries.get(key);
                if (entry == null) {
                    entry = new Entry(sol);
                    entries.put(key, entry);
                }
                entry.addSolution(sol);
            }
            Collection<Entry> collection = entries.values();
            return collection;
        }
        finally {
            iter.close();
        }
    }

    private Value processAggregate(Set<BindingSet> bindingSets, AggregateOperator operator) throws QueryEvaluationException {
        if (operator instanceof Count) {
            Count countOp = (Count)operator;
            ValueExpr arg = countOp.getArg();
            if (arg != null) {
                Set<Value> values = this.makeValueSet(arg, bindingSets);
                return new LiteralImpl(Integer.toString(values.size()), XMLSchema.INTEGER);
            }
            return new LiteralImpl(Integer.toString(bindingSets.size()), XMLSchema.INTEGER);
        }
        if (operator instanceof Min) {
            Min minOp = (Min)operator;
            Set<Value> values = this.makeValueSet(minOp.getArg(), bindingSets);
            double min = Double.POSITIVE_INFINITY;
            for (Value v : values) {
                if (!(v instanceof Literal)) continue;
                Literal l = (Literal)v;
                try {
                    min = Math.min(min, Double.parseDouble(l.getLabel()));
                }
                catch (NumberFormatException e) {}
            }
            return new LiteralImpl(Double.toString(min), XMLSchema.DOUBLE);
        }
        if (operator instanceof Max) {
            Max maxOp = (Max)operator;
            Set<Value> values = this.makeValueSet(maxOp.getArg(), bindingSets);
            double max = Double.NEGATIVE_INFINITY;
            for (Value v : values) {
                if (!(v instanceof Literal)) continue;
                Literal l = (Literal)v;
                try {
                    max = Math.max(max, Double.parseDouble(l.getLabel()));
                }
                catch (NumberFormatException e) {}
            }
            return new LiteralImpl(Double.toString(max), XMLSchema.DOUBLE);
        }
        return null;
    }

    private Set<Value> makeValueSet(ValueExpr arg, Set<BindingSet> bindingSets) throws QueryEvaluationException {
        HashSet<Value> valueSet = new HashSet<Value>();
        for (BindingSet s : bindingSets) {
            Value value = this.strategy.evaluate(arg, s);
            if (value == null) continue;
            valueSet.add(value);
        }
        return valueSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry {
        private BindingSet prototype;
        private Set<BindingSet> bindingSets;

        public Entry(BindingSet prototype) {
            this.prototype = prototype;
            this.bindingSets = new HashSet<BindingSet>();
        }

        public BindingSet getPrototype() {
            return this.prototype;
        }

        public void addSolution(BindingSet bindingSet) {
            this.bindingSets.add(bindingSet);
        }

        public Set<BindingSet> getSolutions() {
            return this.bindingSets;
        }
    }

    protected class Key {
        private BindingSet bindingSet;
        private int hash;

        public Key(BindingSet bindingSet) {
            this.bindingSet = bindingSet;
            for (String name : GroupIterator.this.group.getGroupBindingNames()) {
                Value value = bindingSet.getValue(name);
                if (value == null) continue;
                this.hash ^= value.hashCode();
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (other instanceof Key && other.hashCode() == this.hash) {
                BindingSet otherSolution = ((Key)other).bindingSet;
                for (String name : GroupIterator.this.group.getGroupBindingNames()) {
                    Value v2;
                    Value v1 = this.bindingSet.getValue(name);
                    if (ObjectUtil.nullEquals(v1, v2 = otherSolution.getValue(name))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

