/*
 * synergy -- mouse and keyboard sharing utility
 * Copyright (C) 2002 Chris Schoeneman
 * 
 * This package is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * found in the file COPYING that should have accompanied this file.
 * 
 * This package is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef MOUSETYPES_H
#define MOUSETYPES_H

#include "BasicTypes.h"

//! Mouse button ID
/*!
Type to hold a mouse button identifier.
*/
typedef UInt8			ButtonID;

//! @name Mouse button identifiers
//@{
static const ButtonID	kButtonNone   = 0;
static const ButtonID	kButtonLeft   = 1;
static const ButtonID	kButtonMiddle = 2;
static const ButtonID	kButtonRight  = 3;
static const ButtonID	kButtonExtra0 = 4;
//@}

#endif
